/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.SubscribeResourceUserDao;
import com.baijia.umgzh.dal.po.SubscribeResourceUserPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class SubscribeResourceUserDaoImpl
extends AdDaoSupport
implements SubscribeResourceUserDao {
    private static final Logger log = LoggerFactory.getLogger(SubscribeResourceUserDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer save(final String openId, final Integer resourceId, final Boolean status, final Integer index) {
        final String sql = "insert into um.am_subscribe_resource_user_info (open_id, resource_id, status, `index`) values (?, ?, ?, ?) on duplicate key update `index`=values(`index`), status=values(status)";
        log.info("sql: {}, openId: {}, resourceId: {}, status: {}, index: {}", new Object[]{sql, openId, resourceId, status, index});
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                ps.setString(1, openId);
                ps.setInt(2, resourceId);
                ps.setBoolean(3, status);
                ps.setInt(4, index);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return ret;
    }

    @Override
    public List<Integer> getListByOpenId(String openId, Integer index, Boolean status) {
        String sql = "select resource_id from um.am_subscribe_resource_user_info where open_id = ? and `index` = ? and status = ?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(openId);
        params.add(index);
        params.add(status);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        List resourceList = this.getJdbcTemplate().queryForList(sql, params.toArray(), Integer.class);
        if (CollectionUtils.isEmpty((Collection)resourceList)) {
            return null;
        }
        return resourceList;
    }

    @Override
    public List<SubscribeResourceUserPo> getUnPushResourceList(String openId) {
        String sql = "select * from um.am_subscribe_resource_user_info where open_id = ? and status = 0 order by update_time desc";
        ArrayList<String> params = new ArrayList<String>();
        params.add(openId);
        log.info("sql: {}, param: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            List resourceList = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<SubscribeResourceUserPo>(){

                public SubscribeResourceUserPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return SubscribeResourceUserDaoImpl.this.buildSubscribeResourceUserPo(rs);
                }
            });
            if (CollectionUtils.isEmpty((Collection)resourceList)) {
                return null;
            }
            return resourceList;
        }
        catch (Exception ex) {
            log.info(ex.toString());
            return null;
        }
    }

    @Override
    public void updateStatusByOpenIdResourceId(String openId, Integer resourceId) {
        String sql = String.format("update um.am_subscribe_resource_user_info set status=1 where open_id='%s' and resource_id=%d", openId, resourceId);
        this.getJdbcTemplate().update(sql);
    }

    private SubscribeResourceUserPo buildSubscribeResourceUserPo(ResultSet rs) throws SQLException {
        SubscribeResourceUserPo userPo = new SubscribeResourceUserPo();
        userPo.setOpenId(rs.getString("open_id"));
        userPo.setResourceId(rs.getInt("resource_id"));
        userPo.setStatus(rs.getBoolean("status"));
        userPo.setIndex(rs.getInt("index"));
        userPo.setId(rs.getInt("id"));
        return userPo;
    }
}

