/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.SubscribeResourceListDao;
import com.baijia.umgzh.dal.po.SubscribeResourceListPo;
import com.google.gson.Gson;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class SubscribeResourceListDaoImpl
extends AdDaoSupport
implements SubscribeResourceListDao {
    private static final Logger log = LoggerFactory.getLogger(SubscribeResourceListDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public List<SubscribeResourceListPo> getListByPageIndex(Integer index) {
        String sql = "select * from um.am_subscribe_resource_list where `index` = ? and status=1";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(index);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            List resourceListPos = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<SubscribeResourceListPo>(){

                public SubscribeResourceListPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return SubscribeResourceListDaoImpl.this.buildSubscribeResourceListPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)resourceListPos));
            if (CollectionUtils.isEmpty((Collection)resourceListPos)) {
                return null;
            }
            return resourceListPos;
        }
        catch (Exception ex) {
            log.info(ex.toString());
            return null;
        }
    }

    @Override
    public SubscribeResourceListPo getResourcebyId(Integer id) {
        String sql = "select * from um.am_subscribe_resource_list where id = ?";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(id);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            SubscribeResourceListPo resourceListPo = (SubscribeResourceListPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<SubscribeResourceListPo>(){

                public SubscribeResourceListPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return SubscribeResourceListDaoImpl.this.buildSubscribeResourceListPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)resourceListPo));
            return resourceListPo;
        }
        catch (Exception ex) {
            log.info(ex.toString());
            return null;
        }
    }

    private SubscribeResourceListPo buildSubscribeResourceListPo(ResultSet rs) throws SQLException {
        SubscribeResourceListPo resourceListPo = new SubscribeResourceListPo();
        resourceListPo.setId(rs.getInt("id"));
        resourceListPo.setAccountId(rs.getInt("account_id"));
        resourceListPo.setDescription(rs.getString("description"));
        resourceListPo.setImgUrl(rs.getString("img_url"));
        resourceListPo.setKeyword(rs.getString("keyword"));
        resourceListPo.setStatus(rs.getBoolean("status"));
        resourceListPo.setIndex(rs.getInt("index"));
        return resourceListPo;
    }
}

