/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GroupGongzhonghaoUserConnDao;
import com.baijia.umgzh.dal.po.GroupGongzhonghaoUserConnPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component(value="groupGongzhonghaoUserConnDao")
public class GroupGongzhonghaoUserConnDaoImpl
extends AdDaoSupport
implements GroupGongzhonghaoUserConnDao {
    private static final Logger log = LoggerFactory.getLogger(GroupGongzhonghaoUserConnDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer saveOrUpdate(GroupGongzhonghaoUserConnPo userConnPo) {
        return null;
    }

    @Override
    public Integer save(final GroupGongzhonghaoUserConnPo userConnPo) {
        String sql = "insert into um.am_group_gongzhonghao_user_conn(app_id, open_id, wechat_id) values(?, ?, ?) on duplicate key update app_id=values(app_id), wechat_id=values(wechat_id)";
        log.info("sql: {}, params: {}", (Object)"insert into um.am_group_gongzhonghao_user_conn(app_id, open_id, wechat_id) values(?, ?, ?) on duplicate key update app_id=values(app_id), wechat_id=values(wechat_id)", (Object)gson.toJson((Object)userConnPo));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("insert into um.am_group_gongzhonghao_user_conn(app_id, open_id, wechat_id) values(?, ?, ?) on duplicate key update app_id=values(app_id), wechat_id=values(wechat_id)", 1);
                ps.setString(1, userConnPo.getAppId());
                ps.setString(2, userConnPo.getOpenId());
                ps.setString(3, userConnPo.getWechatId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return ret;
    }

    @Override
    public Integer update(final GroupGongzhonghaoUserConnPo userConnPo) {
        String sql = "update um.am_group_gongzhonghao_user_conn set wechat_id=? where open_id=?";
        log.info("sql: {}, params: {}", (Object)"update um.am_group_gongzhonghao_user_conn set wechat_id=? where open_id=?", (Object)gson.toJson((Object)userConnPo));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_group_gongzhonghao_user_conn set wechat_id=? where open_id=?", 1);
                ps.setString(1, userConnPo.getOpenId());
                ps.setString(2, userConnPo.getOpenId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return ret;
    }

    @Override
    public String getWechatIdByOpenId(String openId) {
        String sql = "select wechat_id from um.am_group_gongzhonghao_user_conn where open_id= ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(openId);
        try {
            String wechatId = (String)this.getJdbcTemplate().queryForObject(sql, params.toArray(), String.class);
            return wechatId;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public String getOpenIdByWechatId(String wechatId, String appId) {
        String sql = "select open_id from um.am_group_gongzhonghao_user_conn where app_id= ? and wechat_id=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        params.add(wechatId);
        try {
            String openId = (String)this.getJdbcTemplate().queryForObject(sql, params.toArray(), String.class);
            return openId;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private GroupGongzhonghaoUserConnPo buildUserConnPo(ResultSet rs) throws SQLException {
        GroupGongzhonghaoUserConnPo connPo = new GroupGongzhonghaoUserConnPo();
        connPo.setId(rs.getInt("id"));
        connPo.setAppId(rs.getString("app_id"));
        connPo.setWechatId(rs.getString("wechat_id"));
        connPo.setOpenId(rs.getString("open_id"));
        return connPo;
    }
}

