/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GroupFansTaskDao;
import com.baijia.umgzh.dal.po.GroupFansTaskPo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GroupFansTaskDaoImpl
extends AdDaoSupport
implements GroupFansTaskDao {
    private static final Logger log = LoggerFactory.getLogger(GroupFansTaskDaoImpl.class);

    @Override
    public GroupFansTaskPo getInfoByTaskId(Integer taskId) {
        String sql = "select * from um.am_group_fans_task_id where task_id = ? and status=1";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(taskId);
        log.info("sql:{}, taskId:{}", (Object)sql, (Object)taskId);
        try {
            GroupFansTaskPo groupFansTaskPo = (GroupFansTaskPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GroupFansTaskPo>(){

                public GroupFansTaskPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GroupFansTaskDaoImpl.this.buildGroupFansTaskPo(rs);
                }
            });
            return groupFansTaskPo;
        }
        catch (Exception ex) {
            log.info("exception: " + ex);
            return null;
        }
    }

    @Override
    public Integer save(final Integer taskId, final Boolean status) {
        final String sql = "INSERT INTO um.am_group_fans_task_id(task_id, status) values (?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, taskId:{}, status: {}", new Object[]{sql, taskId, status});
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                ps.setInt(1, taskId);
                ps.setBoolean(2, status);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("keyHolder.getKey().intValue(): " + keyHolder.getKey().intValue());
        return keyHolder.getKey().intValue();
    }

    private GroupFansTaskPo buildGroupFansTaskPo(ResultSet rs) throws SQLException {
        GroupFansTaskPo groupFansTaskPo = new GroupFansTaskPo();
        groupFansTaskPo.setId(rs.getInt("id"));
        groupFansTaskPo.setTaskId(rs.getInt("task_id"));
        groupFansTaskPo.setStatus(rs.getBoolean("status"));
        return groupFansTaskPo;
    }
}

