/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.AuthorizedGongzhonghaoDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoUserDao;
import com.baijia.umgzh.dal.po.AuthorizedGongzhonghaoPo;
import com.baijia.umgzh.dal.po.GongzhonghaoUserPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component(value="gongzhonghaoUserDao")
public class GongzhonghaoUserDaoImpl
extends AdDaoSupport
implements GongzhonghaoUserDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoUserDaoImpl.class);
    private static Gson gson = new Gson();
    @Resource
    private AuthorizedGongzhonghaoDao authorizedGongzhonghaoDao;

    @Override
    public int saveOrUpdate(GongzhonghaoUserPo userInfo) {
        GongzhonghaoUserPo userPo = this.getInfoByOpenid(userInfo.getOpenid());
        log.info("\u7528\u6237\u662f\u5426\u5b58\u5728\uff1a {}", (Object)gson.toJson((Object)userPo));
        if (userPo == null) {
            return this.save(userInfo);
        }
        userInfo.setId(userPo.getId());
        if (userInfo.getUnionid() == null) {
            userInfo.setUnionid("");
        }
        return this.update(userInfo);
    }

    private int save(final GongzhonghaoUserPo userInfo) {
        String taginfo = this.buildTagList(userInfo.getTagidList());
        try {
            String sql = "insert into um.am_gongzhonghao_user(openid, unionid, city, province, country, headimgurl, language, nickname, remark, sex, gongzhonghao_id, subscribe_time,tagid_list,ori_nickname) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            final String nickname = userInfo.getNickname();
            final String tagInfofinal = taginfo;
            String oriNickName = userInfo.getNickname();
            log.info("sql : {}, params: {}", (Object)"insert into um.am_gongzhonghao_user(openid, unionid, city, province, country, headimgurl, language, nickname, remark, sex, gongzhonghao_id, subscribe_time,tagid_list,ori_nickname) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object)gson.toJson((Object)userInfo));
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.getJdbcTemplate().update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement("insert into um.am_gongzhonghao_user(openid, unionid, city, province, country, headimgurl, language, nickname, remark, sex, gongzhonghao_id, subscribe_time,tagid_list,ori_nickname) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
                    ps.setString(1, userInfo.getOpenid());
                    ps.setString(2, userInfo.getUnionid());
                    ps.setString(3, userInfo.getCity());
                    ps.setString(4, userInfo.getProvince());
                    ps.setString(5, userInfo.getCountry());
                    ps.setString(6, userInfo.getHeadimgurl());
                    ps.setString(7, userInfo.getLanguage());
                    ps.setString(8, nickname);
                    ps.setString(9, userInfo.getRemark());
                    ps.setInt(10, userInfo.getSex());
                    ps.setString(11, userInfo.getGongzhonghaoId());
                    ps.setLong(12, userInfo.getSubscribeTime());
                    ps.setString(13, tagInfofinal);
                    ps.setString(14, userInfo.getOriNickname());
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            userInfo.setId(keyHolder.getKey().intValue());
            log.info(String.format("save - sql:{}, newId:{}", "insert into um.am_gongzhonghao_user(openid, unionid, city, province, country, headimgurl, language, nickname, remark, sex, gongzhonghao_id, subscribe_time,tagid_list,ori_nickname) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", userInfo.getId()));
            return userInfo.getId();
        }
        catch (Exception e) {
            log.info("save user exception: {}", (Throwable)e);
            return -1;
        }
    }

    private int update(final GongzhonghaoUserPo userInfo) {
        final String taginfo = this.buildTagList(userInfo.getTagidList());
        try {
            final String sql = "update um.am_gongzhonghao_user set unionid=?, city=?, province=?, country = ?, headimgurl = ?, language= ?, nickname= ?, remark= ?, sex= ?, gongzhonghao_id = ? ,subscribe_time= ?, tagid_list= ? ,ori_nickname = ? where openid= ?";
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement ps = con.prepareStatement(sql, 1);
                    ps.setString(1, userInfo.getUnionid());
                    ps.setString(2, userInfo.getCity());
                    ps.setString(3, userInfo.getProvince());
                    ps.setString(4, userInfo.getCountry());
                    ps.setString(5, userInfo.getHeadimgurl());
                    ps.setString(6, userInfo.getLanguage());
                    ps.setString(7, userInfo.getNickname());
                    ps.setString(8, userInfo.getRemark());
                    ps.setInt(9, userInfo.getSex());
                    ps.setString(10, userInfo.getGongzhonghaoId());
                    ps.setLong(11, userInfo.getSubscribeTime());
                    ps.setString(12, taginfo);
                    ps.setString(13, userInfo.getOriNickname());
                    ps.setString(14, userInfo.getOpenid());
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            log.info("updateStatus - sql:{}, params:{}, ret:{}", new Object[]{sql, gson.toJson((Object)userInfo), ret});
            return ret;
        }
        catch (Exception e) {
            log.info("update user: {}", (Throwable)e);
            return -1;
        }
    }

    @Override
    public GongzhonghaoUserPo getInfoByOpenid(String openid) {
        String sql = "select * from um.am_gongzhonghao_user where openid=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(openid);
        if (this.getResult("select * from um.am_gongzhonghao_user where openid=?", params) != null) {
            return this.getResult("select * from um.am_gongzhonghao_user where openid=?", params).get(0);
        }
        return null;
    }

    @Override
    public GongzhonghaoUserPo getInfoByOpenidAndGongzhonghao(String openid, String gongzhonghaoId) {
        String sql = "select * from um.am_gongzhonghao_user where openid=? and gongzhonghao_id=?";
        Object[] params = new Object[]{openid, gongzhonghaoId};
        log.info(String.format("sql:{}, params:{}", "select * from um.am_gongzhonghao_user where openid=? and gongzhonghao_id=?", gson.toJson((Object)params)));
        try {
            List list = this.getJdbcTemplate().query("select * from um.am_gongzhonghao_user where openid=? and gongzhonghao_id=?", params, (RowMapper)new RowMapper<GongzhonghaoUserPo>(){

                public GongzhonghaoUserPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoUserDaoImpl.this.buildGongzhonghaoUserPo(rs);
                }
            });
            log.info(String.format("sql:{}, params:{}, result:{}", "select * from um.am_gongzhonghao_user where openid=? and gongzhonghao_id=?", gson.toJson((Object)params), gson.toJson((Object)list)));
            if (list == null || list.size() == 0) {
                return null;
            }
            return (GongzhonghaoUserPo)list.get(0);
        }
        catch (Exception ex) {
            log.info("exception: {}, ex");
            return null;
        }
    }

    @Override
    public List<GongzhonghaoUserPo> getMatchUser(String nickName, String groupid) {
        String sql = "select * from um.am_gongzhonghao_user as d, um.openid_group_conn as c  where d.nickName=? and c.groupid = ? and d.openid = c.openid";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(nickName);
        params.add(groupid);
        return this.getResult("select * from um.am_gongzhonghao_user as d, um.openid_group_conn as c  where d.nickName=? and c.groupid = ? and d.openid = c.openid", params);
    }

    @Override
    public List<GongzhonghaoUserPo> getMatchUser(String nickName, String sbNickname, String groupid) {
        if (sbNickname == null) {
            sbNickname = "";
        }
        String sql = "select * from um.am_gongzhonghao_user as d ,um.am_gongzhonghao_openid_group as c  where d.nickName in (?, ?) and c.group_id = ? and d.openid = c.openid";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(nickName);
        params.add(sbNickname);
        params.add(groupid);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        return this.getResult(sql, params);
    }

    @Override
    public int delete(String openid) {
        String sql = String.format("delete from um.am_gongzhonghao_user where openid=\"%s\"", openid);
        log.info(sql);
        Object[] params = new Object[]{};
        return this.getJdbcTemplate().update(sql, params);
    }

    @Override
    public boolean findUserByOpenid(String appId, String openId) {
        AuthorizedGongzhonghaoPo gongzhonghaoPo = this.authorizedGongzhonghaoDao.getInfoByAppid(appId);
        if (gongzhonghaoPo == null) {
            return false;
        }
        String sql = "select * from um.am_gongzhonghao_user where openid=? and gongzhonghao_id=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(openId);
        params.add(gongzhonghaoPo.getGongzhonghaoId());
        return this.getResult(sql, params) != null;
    }

    @Override
    public boolean findUserByNickname(String appId, String nickName, String city) {
        AuthorizedGongzhonghaoPo gongzhonghaoPo = this.authorizedGongzhonghaoDao.getInfoByAppid(appId);
        if (gongzhonghaoPo == null) {
            return false;
        }
        StringBuilder sql = new StringBuilder("select * from um.am_gongzhonghao_user where nickname=? and gongzhonghao_id=?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(nickName);
        params.add(gongzhonghaoPo.getGongzhonghaoId());
        if (!StringUtils.isBlank((CharSequence)city)) {
            sql.append(" and city=?");
            params.add(city);
        }
        boolean res = false;
        if (this.getResult(sql.toString(), params) != null) {
            res = true;
        }
        log.info("sql:{}, params:{}, res:{}", new Object[]{sql, gson.toJson(params), res});
        return res;
    }

    @Override
    public boolean findUserByOpenIdAndGongzhonghaoId(String gongzhonghaoId, String openId) {
        String sql = "select * from um.am_gongzhonghao_user where openid=? and gongzhonghao_id=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(openId);
        params.add(gongzhonghaoId);
        return this.getResult(sql, params) != null;
    }

    @Override
    public GongzhonghaoUserPo getInfoByOpenidAndAppId(String openid, String appId) {
        AuthorizedGongzhonghaoPo gongzhonghaoPo = this.authorizedGongzhonghaoDao.getInfoByAppid(appId);
        if (gongzhonghaoPo == null) {
            return null;
        }
        return this.getInfoByOpenidAndGongzhonghao(openid, gongzhonghaoPo.getGongzhonghaoId());
    }

    @Override
    public GongzhonghaoUserPo getUserInfoByUnionId(String unionId, String gongzhonghaoId) {
        String sql = "select * from um.am_gongzhonghao_user where unionid = ? and gongzhonghao_id = ?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(unionId);
        params.add(gongzhonghaoId);
        List<GongzhonghaoUserPo> gongzhonghaoUserPos = this.getResult("select * from um.am_gongzhonghao_user where unionid = ? and gongzhonghao_id = ?", params);
        if (!CollectionUtils.isEmpty(gongzhonghaoUserPos)) {
            return gongzhonghaoUserPos.get(0);
        }
        return null;
    }

    private GongzhonghaoUserPo buildGongzhonghaoUserPo(ResultSet rs) throws SQLException {
        GongzhonghaoUserPo userPo = new GongzhonghaoUserPo();
        userPo.setId(rs.getInt("id"));
        userPo.setOpenid(rs.getString("openid"));
        try {
            userPo.setNickname(rs.getString("nickname"));
        }
        catch (Exception e) {
            userPo.setNickname("");
        }
        userPo.setSex(rs.getInt("sex"));
        userPo.setCity(rs.getString("city"));
        userPo.setProvince(rs.getString("province"));
        userPo.setCountry(rs.getString("country"));
        userPo.setHeadimgurl(rs.getString("headimgurl"));
        userPo.setLanguage(rs.getString("language"));
        userPo.setUnionid(rs.getString("unionid"));
        userPo.setGroupid(rs.getString("groupid"));
        userPo.setRemark(rs.getString("remark"));
        userPo.setTagidList(rs.getString("tagid_list").split(","));
        userPo.setSubscribeTime(rs.getLong("subscribe_time"));
        userPo.setGongzhonghaoId(rs.getString("gongzhonghao_id"));
        return userPo;
    }

    private List<GongzhonghaoUserPo> getResult(String sql, List<Object> params) {
        try {
            log.info("sql: {}", (Object)sql);
            List list = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoUserPo>(){

                public GongzhonghaoUserPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoUserDaoImpl.this.buildGongzhonghaoUserPo(rs);
                }
            });
            log.info("result: {}, size: {}", (Object)gson.toJson((Object)list), (Object)list.size());
            if (null == list || list.size() == 0) {
                return null;
            }
            return list;
        }
        catch (Exception ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    private String buildTagList(String[] tagidList) {
        String taginfo = "";
        if (tagidList == null) {
            return taginfo;
        }
        for (String tag : tagidList) {
            taginfo = !taginfo.equals("") ? taginfo + "," : taginfo + tag;
        }
        return taginfo;
    }
}

