/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoSummaryDataDao;
import com.baijia.umgzh.dal.po.GongzhonghaoSummaryDataPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoSummaryDataDaoImpl
extends AdDaoSupport
implements GongzhonghaoSummaryDataDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoSummaryDataDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer save(final GongzhonghaoSummaryDataPo dataPo) {
        String sql = "insert into um.am_gongzhonghao_summary_data(app_id, create_time, news, new_user, user_cumulate, user_source, cancel_user) values(?, ?, ?, ?, ?, ?, ?) on duplicate key update news=values(news), new_user=values(new_user), user_cumulate=values(user_cumulate), user_source=values(user_source), cancel_user=values(cancel_user)";
        log.info("sql: {}, params: {}", (Object)"insert into um.am_gongzhonghao_summary_data(app_id, create_time, news, new_user, user_cumulate, user_source, cancel_user) values(?, ?, ?, ?, ?, ?, ?) on duplicate key update news=values(news), new_user=values(new_user), user_cumulate=values(user_cumulate), user_source=values(user_source), cancel_user=values(cancel_user)", (Object)gson.toJson((Object)dataPo));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        final String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(new Date().getTime() - 86400000L));
        try {
            int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement("insert into um.am_gongzhonghao_summary_data(app_id, create_time, news, new_user, user_cumulate, user_source, cancel_user) values(?, ?, ?, ?, ?, ?, ?) on duplicate key update news=values(news), new_user=values(new_user), user_cumulate=values(user_cumulate), user_source=values(user_source), cancel_user=values(cancel_user)", 1);
                    ps.setString(1, dataPo.getAppId());
                    ps.setString(2, date);
                    ps.setInt(3, dataPo.getNews());
                    ps.setInt(4, dataPo.getNewUser());
                    ps.setInt(5, dataPo.getUserCumulate());
                    ps.setInt(6, dataPo.getUserSource());
                    ps.setInt(7, dataPo.getCancelUser());
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            return ret;
        }
        catch (Exception ex) {
            log.info("insert error: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public GongzhonghaoSummaryDataPo getGongzhonghaoSummaryDataByAppid(String appId) {
        String sql = "select * from um.am_gongzhonghao_summary_data where app_id = ? and create_time = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        params.add(new SimpleDateFormat("yyyy-MM-dd").format(new Date(new Date().getTime() - 86400000L)));
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            GongzhonghaoSummaryDataPo menuPo = (GongzhonghaoSummaryDataPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoSummaryDataPo>(){

                public GongzhonghaoSummaryDataPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoSummaryDataDaoImpl.this.buildGongzhonghaoSummaryDataPo(rs);
                }
            });
            return menuPo;
        }
        catch (EmptyResultDataAccessException e) {
            log.info("error: {}", (Throwable)e);
            return null;
        }
    }

    GongzhonghaoSummaryDataPo buildGongzhonghaoSummaryDataPo(ResultSet rs) throws SQLException {
        GongzhonghaoSummaryDataPo dataPo = new GongzhonghaoSummaryDataPo();
        dataPo.setId(rs.getInt("id"));
        dataPo.setAppId(rs.getString("app_id"));
        dataPo.setCreateTime(rs.getDate("create_time").toString());
        dataPo.setNews(rs.getInt("news"));
        dataPo.setNewUser(rs.getInt("new_user"));
        dataPo.setUserSource(rs.getInt("user_source"));
        dataPo.setCancelUser(rs.getInt("cancel_user"));
        dataPo.setUserCumulate(rs.getInt("user_cumulate"));
        return dataPo;
    }

    public static void main(String[] args) {
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(new Date().getTime() - 86400000L));
        System.out.println(date);
    }
}

