/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.support.web.dto.PageDto;
import com.baijia.umgzh.dal.bo.GongzhonghaoQrcodeReplyBo;
import com.baijia.umgzh.dal.dao.GongzhonghaoGroupDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoQrcodeReplyDao;
import com.baijia.umgzh.dal.po.GongzhonghaoQrcodeReplyPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoQrcodeReplyDaoImpl
extends AdDaoSupport
implements GongzhonghaoQrcodeReplyDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoQrcodeReplyDaoImpl.class);
    private static Gson gson = new Gson();
    @Resource
    private GongzhonghaoGroupDao gongzhonghaoGroupDao;

    @Override
    public Boolean save(final GongzhonghaoQrcodeReplyPo qrcodeReplyPo) {
        String sql = "INSERT INTO um.am_gongzhonghao_qrcode_reply(category_id, limitation, preference_group_id, auto_create, auto_qrcode, group_prefix, group_number, group_suffix, robot_admin, current_number, is_open_groups, user_define, img_url, img_name, admin_wechat_id_list) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}", (Object)"INSERT INTO um.am_gongzhonghao_qrcode_reply(category_id, limitation, preference_group_id, auto_create, auto_qrcode, group_prefix, group_number, group_suffix, robot_admin, current_number, is_open_groups, user_define, img_url, img_name, admin_wechat_id_list) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object)gson.toJson((Object)qrcodeReplyPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO um.am_gongzhonghao_qrcode_reply(category_id, limitation, preference_group_id, auto_create, auto_qrcode, group_prefix, group_number, group_suffix, robot_admin, current_number, is_open_groups, user_define, img_url, img_name, admin_wechat_id_list) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
                ps.setInt(1, qrcodeReplyPo.getCategoryId());
                ps.setInt(2, qrcodeReplyPo.getLimitation());
                ps.setString(3, qrcodeReplyPo.getPreferenceGroupId());
                ps.setBoolean(4, qrcodeReplyPo.getAutoCreate());
                ps.setBoolean(5, qrcodeReplyPo.getAutoQrcode());
                ps.setString(6, qrcodeReplyPo.getGroupPrefix());
                ps.setString(7, qrcodeReplyPo.getGroupNumber());
                ps.setString(8, qrcodeReplyPo.getGroupSuffix());
                ps.setBoolean(9, qrcodeReplyPo.getRobotAdmin());
                ps.setInt(10, qrcodeReplyPo.getCurrentNumber());
                ps.setBoolean(11, qrcodeReplyPo.getIsOpenGroups());
                ps.setBoolean(12, qrcodeReplyPo.getIsUserDefine());
                ps.setString(13, qrcodeReplyPo.getImgUrl());
                ps.setString(14, qrcodeReplyPo.getImgName());
                if (CollectionUtils.isEmpty(qrcodeReplyPo.getAdminWechatIdList())) {
                    ps.setString(15, "");
                } else {
                    ps.setString(15, gson.toJson(qrcodeReplyPo.getAdminWechatIdList()));
                }
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("result: {}", (Object)ret);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean update(final GongzhonghaoQrcodeReplyPo qrcodeReplyPo) {
        String sql = "update um.am_gongzhonghao_qrcode_reply set limitation = ?, preference_group_id = ?, auto_create = ?, auto_qrcode= ?, group_prefix= ?, group_number= ?, group_suffix=?, robot_admin=?, is_open_groups=?, user_define=?, img_url=?, img_name=?, pos_x=?, pos_y=?, width=?, height=?, admin_wechat_id_list = ? where id=?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}", (Object)"update um.am_gongzhonghao_qrcode_reply set limitation = ?, preference_group_id = ?, auto_create = ?, auto_qrcode= ?, group_prefix= ?, group_number= ?, group_suffix=?, robot_admin=?, is_open_groups=?, user_define=?, img_url=?, img_name=?, pos_x=?, pos_y=?, width=?, height=?, admin_wechat_id_list = ? where id=?", (Object)gson.toJson((Object)qrcodeReplyPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_gongzhonghao_qrcode_reply set limitation = ?, preference_group_id = ?, auto_create = ?, auto_qrcode= ?, group_prefix= ?, group_number= ?, group_suffix=?, robot_admin=?, is_open_groups=?, user_define=?, img_url=?, img_name=?, pos_x=?, pos_y=?, width=?, height=?, admin_wechat_id_list = ? where id=?", 1);
                ps.setInt(1, qrcodeReplyPo.getLimitation());
                ps.setString(2, qrcodeReplyPo.getPreferenceGroupId());
                ps.setBoolean(3, qrcodeReplyPo.getAutoCreate());
                ps.setBoolean(4, qrcodeReplyPo.getAutoQrcode());
                ps.setString(5, qrcodeReplyPo.getGroupPrefix());
                ps.setString(6, qrcodeReplyPo.getGroupNumber());
                ps.setString(7, qrcodeReplyPo.getGroupSuffix());
                ps.setBoolean(8, qrcodeReplyPo.getRobotAdmin());
                ps.setBoolean(9, qrcodeReplyPo.getIsOpenGroups());
                ps.setBoolean(10, qrcodeReplyPo.getIsUserDefine());
                ps.setString(11, qrcodeReplyPo.getImgUrl());
                ps.setString(12, qrcodeReplyPo.getImgName());
                ps.setInt(13, qrcodeReplyPo.getPosX());
                ps.setInt(14, qrcodeReplyPo.getPosY());
                ps.setInt(15, qrcodeReplyPo.getWidth());
                ps.setInt(16, qrcodeReplyPo.getHeight());
                if (CollectionUtils.isEmpty(qrcodeReplyPo.getAdminWechatIdList())) {
                    ps.setString(17, "");
                } else {
                    ps.setString(17, gson.toJson(qrcodeReplyPo.getAdminWechatIdList()));
                }
                ps.setInt(18, qrcodeReplyPo.getId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        if (ret > 0) {
            GongzhonghaoQrcodeReplyBo replyBo = this.getById(qrcodeReplyPo.getId());
            this.gongzhonghaoGroupDao.updateSelectChatroomSelect(replyBo.getCategoryId(), 0);
            this.gongzhonghaoGroupDao.updateChatroomByGroupid(qrcodeReplyPo.getPreferenceGroupId(), 1);
            return true;
        }
        return false;
    }

    @Override
    public Boolean saveOrUpdate(GongzhonghaoQrcodeReplyPo qrcodeReplyPo) {
        GongzhonghaoQrcodeReplyBo qrcodeReplyBo = this.getByCategoryId(qrcodeReplyPo.getCategoryId());
        log.info("params: {}, result:{}", (Object)gson.toJson((Object)qrcodeReplyPo), (Object)gson.toJson((Object)qrcodeReplyBo));
        if (qrcodeReplyBo != null) {
            qrcodeReplyPo.setId(qrcodeReplyBo.getId());
            return this.update(qrcodeReplyPo);
        }
        return this.save(qrcodeReplyPo);
    }

    @Override
    public GongzhonghaoQrcodeReplyBo getById(Integer id) {
        String sql = " SELECT * FROM um.am_gongzhonghao_qrcode_reply WHERE id = ? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(id);
        log.info("sql: {}, params: {}", (Object)sql, params);
        try {
            GongzhonghaoQrcodeReplyBo qrcodeReplyBo = (GongzhonghaoQrcodeReplyBo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoQrcodeReplyBo>(){

                public GongzhonghaoQrcodeReplyBo mapRow(ResultSet rs, int i) throws SQLException {
                    GongzhonghaoQrcodeReplyBo replyBo = new GongzhonghaoQrcodeReplyBo();
                    replyBo.setId(rs.getInt("id"));
                    replyBo.setCategoryId(rs.getInt("category_id"));
                    replyBo.setLimitation(rs.getInt("limitation"));
                    replyBo.setPreferenceGroupId(rs.getString("preference_group_id"));
                    replyBo.setAutoQRCode(rs.getBoolean("auto_qrcode"));
                    replyBo.setAutoCreate(rs.getBoolean("auto_create"));
                    replyBo.setIsOpenGroups(rs.getBoolean("is_open_groups"));
                    ArrayList<String> list = new ArrayList<String>();
                    if (rs.getBoolean("auto_create")) {
                        list.add(rs.getString("group_prefix"));
                        list.add(rs.getString("group_number"));
                        list.add(rs.getString("group_suffix"));
                        replyBo.setNamePartterns(list);
                    } else {
                        replyBo.setNamePartterns(list);
                    }
                    replyBo.setRobotAdmin(rs.getBoolean("robot_admin"));
                    replyBo.setIsUserDefine(rs.getBoolean("user_define"));
                    replyBo.setImgUrl(rs.getString("img_url"));
                    replyBo.setImgName(rs.getString("img_name"));
                    replyBo.setCreateTime(rs.getTimestamp("create_time"));
                    replyBo.setUpdateTime(rs.getTimestamp("update_time"));
                    if (StringUtils.isNotBlank((CharSequence)rs.getString("admin_wechat_id_list"))) {
                        replyBo.setAdminWechatIdList((List)gson.fromJson(rs.getString("admin_wechat_id_list"), List.class));
                    }
                    return replyBo;
                }
            });
            log.info("reslt: {}", (Object)gson.toJson((Object)qrcodeReplyBo));
            return qrcodeReplyBo;
        }
        catch (Exception ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<GongzhonghaoQrcodeReplyBo> getListByAccountId(Integer acountId, PageDto pageDto) {
        String sql = "select a.id as id, category_id, limitation, preference_group_id, auto_create, auto_qrcode, group_prefix, group_number, group_suffix, robot_admin, current_number, name, is_open_groups, user_define, img_url, pos_x, pos_y, width, height, img_name, a.create_time create_time, a.update_time update_time, a.admin_wechat_id_list admin_wechat_id_list  from um.am_gongzhonghao_qrcode_reply a left join um.am_category b  on a.category_id=b.id where b.account_id=? and name<>'\u672a\u6307\u5b9a' limit ?, ?";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(acountId);
        params.add((pageDto.getPageNum() - 1) * pageDto.getPageSize());
        params.add(pageDto.getPageSize());
        log.info("sql: {}, params: {}", (Object)sql, params);
        List qrcodeReplyBo = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoQrcodeReplyBo>(){

            public GongzhonghaoQrcodeReplyBo mapRow(ResultSet rs, int i) throws SQLException {
                GongzhonghaoQrcodeReplyBo bo = GongzhonghaoQrcodeReplyDaoImpl.this.buildQrcodeReplyInfo(rs);
                bo.setName(rs.getString("name"));
                return bo;
            }
        });
        if (qrcodeReplyBo == null || qrcodeReplyBo.size() == 0) {
            return null;
        }
        return qrcodeReplyBo;
    }

    @Override
    public Integer getAllCount(Integer accountId) {
        String sql = "select count(*) from um.am_gongzhonghao_qrcode_reply a left join um.am_category b on a.category_id=b.id where b.account_id=? and name<>'\u672a\u6307\u5b9a'";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(accountId);
        log.info("sql: {}, params: {}", (Object)sql, params);
        return (Integer)this.getJdbcTemplate().queryForObject(sql, params.toArray(), Integer.class);
    }

    @Override
    public void saveDefault(Integer categoryId) {
        GongzhonghaoQrcodeReplyPo replyPo = this.buildDefaultPo(categoryId);
        this.saveOrUpdate(replyPo);
    }

    @Override
    public void deleteCategoryIds(List<Integer> categoryIds) {
        final StringBuilder sql = new StringBuilder("delete from um.am_gongzhonghao_qrcode_reply where category_id in (");
        for (int i = 0; i < categoryIds.size(); ++i) {
            sql.append(categoryIds.get(i));
            if (i < categoryIds.size() - 1) {
                sql.append(categoryIds.get(i) + ",");
                continue;
            }
            sql.append(")");
        }
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}", (Object)sql, (Object)gson.toJson(categoryIds));
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql.toString(), 1);
                return ps;
            }
        }, (KeyHolder)keyHolder);
    }

    @Override
    public void saveDafaultList(List<Integer> categoryIds) {
        for (Integer categoryId : categoryIds) {
            GongzhonghaoQrcodeReplyPo replyPo = this.buildDefaultPo(categoryId);
            this.saveOrUpdate(replyPo);
        }
    }

    @Override
    public GongzhonghaoQrcodeReplyBo getByCategoryId(Integer categoryId) {
        String sql = " SELECT * FROM um.am_gongzhonghao_qrcode_reply WHERE category_id = ? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(categoryId);
        log.info("sql: {}, params: {}", (Object)sql, params);
        try {
            GongzhonghaoQrcodeReplyBo qrcodeReplyBo = (GongzhonghaoQrcodeReplyBo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoQrcodeReplyBo>(){

                public GongzhonghaoQrcodeReplyBo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoQrcodeReplyDaoImpl.this.buildQrcodeReplyInfo(rs);
                }
            });
            return qrcodeReplyBo;
        }
        catch (EmptyResultDataAccessException ex) {
            log.info("\u6ca1\u6709\u7ed3\u679c");
            return null;
        }
    }

    @Override
    public void updateCurrentNumber(Integer categoryId, Integer currentNum) {
        GongzhonghaoQrcodeReplyBo qrcodeReplyBo = this.getByCategoryId(categoryId);
        final String sql = String.format("update um.am_gongzhonghao_qrcode_reply set current_number = %d where id = %d", currentNum, qrcodeReplyBo.getId());
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}, currentNum: {}", new Object[]{sql, gson.toJson((Object)qrcodeReplyBo), currentNum});
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                return ps;
            }
        }, (KeyHolder)keyHolder);
    }

    @Override
    public Boolean updateImageFeature(final Integer categoryId, final Integer posX, final Integer posY, final Integer width, final Integer height) {
        String sql = "update um.am_gongzhonghao_qrcode_reply set pos_x=?, pos_y=?, width=?, height=? where category_id=?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_gongzhonghao_qrcode_reply set pos_x=?, pos_y=?, width=?, height=? where category_id=?", 1);
                ps.setInt(1, posX);
                ps.setInt(2, posY);
                ps.setInt(3, width);
                ps.setInt(4, height);
                ps.setInt(5, categoryId);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    private GongzhonghaoQrcodeReplyPo buildDefaultPo(Integer categoryId) {
        GongzhonghaoQrcodeReplyPo po = new GongzhonghaoQrcodeReplyPo();
        po.setCategoryId(categoryId);
        po.setPreferenceGroupId(this.getDefaultGroup(categoryId));
        return po;
    }

    private GongzhonghaoQrcodeReplyBo buildQrcodeReplyInfo(ResultSet rs) throws SQLException {
        GongzhonghaoQrcodeReplyBo replyBo = new GongzhonghaoQrcodeReplyBo();
        replyBo.setId(rs.getInt("id"));
        replyBo.setCategoryId(rs.getInt("category_id"));
        replyBo.setLimitation(rs.getInt("limitation"));
        replyBo.setPreferenceGroupId(rs.getString("preference_group_id"));
        replyBo.setAutoQRCode(rs.getBoolean("auto_qrcode"));
        replyBo.setAutoCreate(rs.getBoolean("auto_create"));
        replyBo.setPreferenceGroup(this.getGroupName(rs.getString("preference_group_id")));
        ArrayList<String> list = new ArrayList<String>();
        list.add(rs.getString("group_prefix"));
        list.add(rs.getString("group_number"));
        list.add(rs.getString("group_suffix"));
        replyBo.setNamePartterns(list);
        replyBo.setRobotAdmin(rs.getBoolean("robot_admin"));
        replyBo.setCurrentNumber(rs.getInt("current_number"));
        replyBo.setIsOpenGroups(rs.getBoolean("is_open_groups"));
        replyBo.setIsUserDefine(rs.getBoolean("user_define"));
        replyBo.setImgUrl(rs.getString("img_url"));
        replyBo.setImgName(rs.getString("img_name"));
        replyBo.setPosX(rs.getInt("pos_x"));
        replyBo.setPosY(rs.getInt("pos_y"));
        replyBo.setWidth(rs.getInt("width"));
        replyBo.setHeight(rs.getInt("height"));
        replyBo.setCreateTime(rs.getTimestamp("create_time"));
        replyBo.setUpdateTime(rs.getTimestamp("update_time"));
        if (StringUtils.isNotBlank((CharSequence)rs.getString("admin_wechat_id_list"))) {
            replyBo.setAdminWechatIdList((List)gson.fromJson(rs.getString("admin_wechat_id_list"), List.class));
        }
        return replyBo;
    }

    private String getDefaultGroup(Integer categoryId) {
        List<String> groupIds = this.gongzhonghaoGroupDao.getChatroomIdByCategoryId(categoryId);
        String selectGroup = this.gongzhonghaoGroupDao.getSelectChatroom(categoryId, 1);
        if (selectGroup != null) {
            return selectGroup;
        }
        if (groupIds != null && groupIds.size() > 0) {
            this.gongzhonghaoGroupDao.updateSelectChatroomSelect(categoryId, 0);
            this.gongzhonghaoGroupDao.updateChatroomByGroupid(groupIds.get(0), 1);
            return groupIds.get(0);
        }
        return null;
    }

    private String getGroupName(String groupId) {
        if (StringUtils.isBlank((CharSequence)groupId)) {
            return null;
        }
        String sql = " SELECT raw_content FROM um.storm_sun_wechat_chatroom WHERE wechat_chatroom= ? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(groupId);
        log.info("sql: {}, params: {}", (Object)sql, params);
        try {
            String raw_content = (String)this.getJdbcTemplate().queryForObject(sql, params.toArray(), String.class);
            log.info("result: {}", (Object)raw_content);
            JSONObject jsonObject = JSONObject.parseObject((String)raw_content);
            log.info("gson: {}", (Object)gson.toJson((Object)jsonObject));
            if (jsonObject.containsKey((Object)"chatroomNickname")) {
                return jsonObject.getString("chatroomNickname");
            }
        }
        catch (EmptyResultDataAccessException ex) {
            log.info("\u6ca1\u6709\u627e\u5230\u7fa4\u5185\u5bb9\uff1a{}", (Object)groupId);
        }
        return null;
    }
}

