/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoMenuDao;
import com.baijia.umgzh.dal.po.GongzhonghaoMenuPo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoMenuDaoImpl
extends AdDaoSupport
implements GongzhonghaoMenuDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoMenuDaoImpl.class);

    @Override
    public GongzhonghaoMenuPo getGongzhonghaoMenuByAppid(String appid) {
        String sql = "select * from um.am_gongzhonghao_menu where app_id = ? order by create_time desc limit 1";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appid);
        try {
            GongzhonghaoMenuPo menuPo = (GongzhonghaoMenuPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoMenuPo>(){

                public GongzhonghaoMenuPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoMenuDaoImpl.this.buildGongzhonghaoMenuPo(rs);
                }
            });
            return menuPo;
        }
        catch (EmptyResultDataAccessException e) {
            log.info("no result: {}", (Throwable)e);
            return null;
        }
    }

    GongzhonghaoMenuPo buildGongzhonghaoMenuPo(ResultSet rs) throws SQLException {
        GongzhonghaoMenuPo menuPo = new GongzhonghaoMenuPo();
        menuPo.setAppId(rs.getString("app_id"));
        menuPo.setMenu(JSONObject.parseObject((String)rs.getString("menu")));
        return menuPo;
    }

    @Override
    public Integer save(final GongzhonghaoMenuPo menuPo) {
        String sql = "INSERT INTO um.am_gongzhonghao_menu(app_id, menu) VALUES(?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("updateStatus - sql:{}, GongzhonghaoMenuPo:{}", (Object)"INSERT INTO um.am_gongzhonghao_menu(app_id, menu) VALUES(?, ?)", (Object)menuPo);
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO um.am_gongzhonghao_menu(app_id, menu) VALUES(?, ?)", 1);
                ps.setString(1, menuPo.getAppId());
                ps.setString(2, menuPo.getMenu().toJSONString());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("keyHolder.getKey().intValue(): " + keyHolder.getKey().intValue());
        return keyHolder.getKey().intValue();
    }

    @Override
    public Integer update(final GongzhonghaoMenuPo menuPo) {
        String sql = "insert into um.am_gongzhonghao_menu (menu, app_id) values (?, ?) on duplicate key update menu=values(menu)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("updateStatus - sql:{}, GongzhonghaoMenuPo:{}", (Object)"insert into um.am_gongzhonghao_menu (menu, app_id) values (?, ?) on duplicate key update menu=values(menu)", (Object)menuPo);
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("insert into um.am_gongzhonghao_menu (menu, app_id) values (?, ?) on duplicate key update menu=values(menu)", 1);
                ps.setString(1, menuPo.getMenu().toJSONString());
                ps.setString(2, menuPo.getAppId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("update result: {}", (Object)ret);
        return ret;
    }

    @Override
    public Integer saveOrUpdate(GongzhonghaoMenuPo menuPo) {
        return this.save(menuPo);
    }
}

