/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoKefuReplyDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoUserDao;
import com.baijia.umgzh.dal.po.GongzhonghaoKefuReplyPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoKefuReplyDaoImpl
extends AdDaoSupport
implements GongzhonghaoKefuReplyDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoKefuReplyDaoImpl.class);
    private static Gson gson = new Gson();
    @Resource
    private GongzhonghaoUserDao gongzhonghaoUserDao;

    @Override
    public Integer save(final GongzhonghaoKefuReplyPo kefuReplyPo) {
        final String sql = "insert into um.am_gongzhonghao_kefu_reply (chat_record_id, from_username, wechat_msg_type, content) values (?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, GongzhonghaoKefuReplyPo:{}", (Object)sql, (Object)gson.toJson((Object)kefuReplyPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(sql, 1);
                ps.setInt(1, kefuReplyPo.getChatRecordId());
                ps.setString(2, kefuReplyPo.getFromUsername());
                ps.setInt(3, kefuReplyPo.getWechatMsgType());
                ps.setString(4, kefuReplyPo.getContent());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("keyHolder.getKey().intValue(): " + keyHolder.getKey().intValue());
        return keyHolder.getKey().intValue();
    }

    @Override
    public Integer update(GongzhonghaoKefuReplyPo replyPo) {
        return null;
    }

    @Override
    public Integer saveOrUpdate(GongzhonghaoKefuReplyPo replyPo) {
        return null;
    }

    @Override
    public List<GongzhonghaoKefuReplyPo> getReplyContent(Integer chatId) {
        String sql = "select * from um.am_gongzhonghao_kefu_reply where chat_record_id=?";
        Object[] params = new Object[]{chatId};
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson((Object)params));
        try {
            List messageRecordBos = this.getJdbcTemplate().query(sql, params, (RowMapper)new RowMapper<GongzhonghaoKefuReplyPo>(){

                public GongzhonghaoKefuReplyPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoKefuReplyDaoImpl.this.buildMsgRecordBo(rs);
                }
            });
            if (messageRecordBos == null || messageRecordBos.size() == 0) {
                return null;
            }
            return messageRecordBos;
        }
        catch (Exception ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    private GongzhonghaoKefuReplyPo buildMsgRecordBo(ResultSet rs) throws SQLException {
        GongzhonghaoKefuReplyPo kefuReplyPo = new GongzhonghaoKefuReplyPo();
        kefuReplyPo.setId(rs.getInt("id"));
        kefuReplyPo.setChatRecordId(rs.getInt("chat_record_id"));
        kefuReplyPo.setFromUsername(rs.getString("from_username"));
        kefuReplyPo.setWechatMsgType(rs.getInt("wechat_msg_type"));
        kefuReplyPo.setContent(rs.getString("content"));
        kefuReplyPo.setCreateTime(rs.getTimestamp("create_time"));
        kefuReplyPo.setUpdateTime(rs.getTimestamp("update_time"));
        return kefuReplyPo;
    }
}

