/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.support.web.dto.PageDto;
import com.baijia.umgzh.dal.bo.JdbcQuerySqlParamsBo;
import com.baijia.umgzh.dal.dao.AuthorizedGongzhonghaoDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoInviteCardTaskDao;
import com.baijia.umgzh.dal.po.AuthorizedGongzhonghaoPo;
import com.baijia.umgzh.dal.po.GongzhonghaoInviteCardTaskPo;
import com.baijia.umgzh.dal.po.GongzhonghaoReplyContentPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoInviteCardTaskDaoImpl
extends AdDaoSupport
implements GongzhonghaoInviteCardTaskDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoInviteCardTaskDaoImpl.class);
    private static Gson gson = new Gson();
    @Resource
    private AuthorizedGongzhonghaoDao authorizedGongzhonghaoDao;

    private Integer save(final GongzhonghaoInviteCardTaskPo inviteCardTaskPo) {
        String sql = "insert into um.am_gongzhonghao_invite_card_task (topic, app_id, keywords, limits, background, styles, card_url, wechat_url, finish_content, owner_open_id, focus_push) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        log.info("sql: {}, params: {}", (Object)"insert into um.am_gongzhonghao_invite_card_task (topic, app_id, keywords, limits, background, styles, card_url, wechat_url, finish_content, owner_open_id, focus_push) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (Object)gson.toJson((Object)inviteCardTaskPo));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("insert into um.am_gongzhonghao_invite_card_task (topic, app_id, keywords, limits, background, styles, card_url, wechat_url, finish_content, owner_open_id, focus_push) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
                ps.setString(1, inviteCardTaskPo.getTopic());
                ps.setString(2, inviteCardTaskPo.getAppId());
                ps.setString(3, inviteCardTaskPo.getKeywords());
                ps.setInt(4, inviteCardTaskPo.getLimits());
                ps.setString(5, inviteCardTaskPo.getBackground());
                ps.setString(6, inviteCardTaskPo.getStyles());
                ps.setString(7, inviteCardTaskPo.getCardUrl());
                ps.setString(8, inviteCardTaskPo.getWechatUrl());
                ps.setString(9, gson.toJson(inviteCardTaskPo.getFinishContent()));
                ps.setString(10, inviteCardTaskPo.getOwnerOpenId());
                ps.setBoolean(11, inviteCardTaskPo.getForcePush());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    private Integer update(final GongzhonghaoInviteCardTaskPo inviteCardTaskPo) {
        String sql = "update um.am_gongzhonghao_invite_card_task set topic=?, app_id=?, keywords=?, limits=?, background=?, styles=?, card_url=?, wechat_url=?, finish_content=?, owner_open_id=?,   focus_push=? where id=?";
        log.info("sql: {}, params: {}", (Object)"update um.am_gongzhonghao_invite_card_task set topic=?, app_id=?, keywords=?, limits=?, background=?, styles=?, card_url=?, wechat_url=?, finish_content=?, owner_open_id=?,   focus_push=? where id=?", (Object)gson.toJson((Object)inviteCardTaskPo));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_gongzhonghao_invite_card_task set topic=?, app_id=?, keywords=?, limits=?, background=?, styles=?, card_url=?, wechat_url=?, finish_content=?, owner_open_id=?,   focus_push=? where id=?", 1);
                ps.setString(1, inviteCardTaskPo.getTopic());
                ps.setString(2, inviteCardTaskPo.getAppId());
                ps.setString(3, inviteCardTaskPo.getKeywords());
                ps.setInt(4, inviteCardTaskPo.getLimits());
                ps.setString(5, inviteCardTaskPo.getBackground());
                ps.setString(6, inviteCardTaskPo.getStyles());
                ps.setString(7, inviteCardTaskPo.getCardUrl());
                ps.setString(8, inviteCardTaskPo.getWechatUrl());
                ps.setString(9, gson.toJson(inviteCardTaskPo.getFinishContent()));
                ps.setString(10, inviteCardTaskPo.getOwnerOpenId());
                ps.setBoolean(11, inviteCardTaskPo.getForcePush());
                ps.setInt(12, inviteCardTaskPo.getId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return ret;
    }

    @Override
    public List<GongzhonghaoInviteCardTaskPo> getTaskList(List<String> appIds, Integer type, PageDto pageDto) {
        StringBuilder sql = new StringBuilder("select * from um.am_gongzhonghao_invite_card_task where ");
        JdbcQuerySqlParamsBo sqlParamsBo = this.getListQuery(appIds, type);
        sql.append(sqlParamsBo.getSql());
        sql.append(" limit ?, ?");
        List<Object> params = sqlParamsBo.getParams();
        params.add((pageDto.getPageNum() - 1) * pageDto.getPageSize());
        params.add(pageDto.getPageSize());
        List<GongzhonghaoInviteCardTaskPo> inviteCardTasks = this.getList(sql.toString(), params);
        return inviteCardTasks;
    }

    @Override
    public Integer getTaskCount(List<String> appIds, Integer type) {
        String sql = "select count(*) from um.am_gongzhonghao_invite_card_task where ";
        JdbcQuerySqlParamsBo sqlParamsBo = this.getListQuery(appIds, type);
        sql = sql + sqlParamsBo.getSql();
        log.info("sql: {}", (Object)sql);
        return (Integer)this.getJdbcTemplate().queryForObject(sql, sqlParamsBo.getParams().toArray(), Integer.class);
    }

    @Override
    public Integer saveOrUpdate(GongzhonghaoInviteCardTaskPo inviteCardTaskPo) {
        if (inviteCardTaskPo.getId() != null) {
            return this.update(inviteCardTaskPo);
        }
        return this.save(inviteCardTaskPo);
    }

    @Override
    public GongzhonghaoInviteCardTaskPo getInfoById(Integer id) {
        String sql = "select * from um.am_gongzhonghao_invite_card_task where id= ?";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(id);
        try {
            return (GongzhonghaoInviteCardTaskPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoInviteCardTaskPo>(){

                public GongzhonghaoInviteCardTaskPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoInviteCardTaskDaoImpl.this.buildInviteCardTaskPo(rs);
                }
            });
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    @Override
    public List<GongzhonghaoInviteCardTaskPo> getInfoByAppId(String appId, Boolean type) {
        StringBuilder sql = new StringBuilder("select * from um.am_gongzhonghao_invite_card_task where app_id= ?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        if (type != null) {
            if (type.booleanValue()) {
                sql.append(" and type=1");
            } else {
                sql.append(" and type=0");
            }
        }
        sql.append(" order by update_time desc");
        log.info("sql: {}, appId: {}", (Object)sql.toString(), (Object)type);
        return this.getList(sql.toString(), params);
    }

    @Override
    public List<GongzhonghaoInviteCardTaskPo> getInfoByKeyword(String keyword, String appId) {
        String sql = "select * from um.am_gongzhonghao_invite_card_task where app_id= ? and type=1 order by update_time desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        List<GongzhonghaoInviteCardTaskPo> inviteCardTasks = this.getList(sql, params);
        if (inviteCardTasks == null || inviteCardTasks.size() == 0) {
            return null;
        }
        ArrayList<GongzhonghaoInviteCardTaskPo> resultList = new ArrayList<GongzhonghaoInviteCardTaskPo>();
        block0: for (GongzhonghaoInviteCardTaskPo inviteCardTask : inviteCardTasks) {
            String keywords = inviteCardTask.getKeywords();
            for (String word : keywords.split(" +")) {
                if (!word.equals(keyword)) continue;
                resultList.add(inviteCardTask);
                continue block0;
            }
        }
        return resultList;
    }

    @Override
    public Integer updateTaskStatus(Integer id, Boolean status) {
        Integer type = status != false ? 1 : 0;
        String sql = String.format("update um.am_gongzhonghao_invite_card_task set type=%d where id=%d", type, id);
        log.info("sql: {}", (Object)sql);
        return this.getJdbcTemplate().update(sql);
    }

    @Override
    public Integer deleteTask(Integer id) {
        String sql = String.format("delete from um.am_gongzhonghao_invite_card_task where id=%d", id);
        return this.getJdbcTemplate().update(sql);
    }

    @Override
    public GongzhonghaoInviteCardTaskPo getTask(Integer taskId) {
        StringBuilder sql = new StringBuilder("select * from um.am_gongzhonghao_invite_card_task where id=?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(taskId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)taskId);
        try {
            GongzhonghaoInviteCardTaskPo inviteCardTask = (GongzhonghaoInviteCardTaskPo)this.getJdbcTemplate().queryForObject(sql.toString(), params.toArray(), (RowMapper)new RowMapper<GongzhonghaoInviteCardTaskPo>(){

                public GongzhonghaoInviteCardTaskPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoInviteCardTaskDaoImpl.this.buildInviteCardTaskPo(rs);
                }
            });
            return inviteCardTask;
        }
        catch (EmptyResultDataAccessException ex) {
            log.info("no result: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void updateQrcodeInfo(Integer id, Integer posx, Integer posy, Integer width, Integer height) {
        String sql = String.format("update um.am_gongzhonghao_invite_card_task set qrcode_posx=%d, qrcode_posy=%d, qrcode_width=%d, qrcode_height=%d where id=%d", posx, posy, width, height, id);
        log.info("sql: {}", (Object)sql);
        this.getJdbcTemplate().update(sql);
    }

    private List<GongzhonghaoInviteCardTaskPo> getList(String sql, List<Object> params) {
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            List inviteCardTasks = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoInviteCardTaskPo>(){

                public GongzhonghaoInviteCardTaskPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoInviteCardTaskDaoImpl.this.buildInviteCardTaskPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)inviteCardTasks));
            if (inviteCardTasks == null || inviteCardTasks.size() == 0) {
                return null;
            }
            return inviteCardTasks;
        }
        catch (EmptyResultDataAccessException ex) {
            return null;
        }
    }

    private GongzhonghaoInviteCardTaskPo buildInviteCardTaskPo(ResultSet rs) throws SQLException {
        GongzhonghaoInviteCardTaskPo inviteCardTaskPo = new GongzhonghaoInviteCardTaskPo();
        inviteCardTaskPo.setId(rs.getInt("id"));
        inviteCardTaskPo.setTopic(rs.getString("topic"));
        inviteCardTaskPo.setAppId(rs.getString("app_id"));
        AuthorizedGongzhonghaoPo authorizedGongzhonghaoPo = this.authorizedGongzhonghaoDao.getInfoByAppid(rs.getString("app_id"));
        inviteCardTaskPo.setGongzhonghaoName(authorizedGongzhonghaoPo.getNickName());
        inviteCardTaskPo.setKeywords(rs.getString("keywords"));
        inviteCardTaskPo.setLimits(rs.getInt("limits"));
        inviteCardTaskPo.setBackground(rs.getString("background"));
        inviteCardTaskPo.setStyles(rs.getString("styles"));
        inviteCardTaskPo.setCardUrl(rs.getString("card_url"));
        inviteCardTaskPo.setWechatUrl(rs.getString("wechat_url"));
        inviteCardTaskPo.setFinishContent(this.buildContents(rs.getString("finish_content")));
        inviteCardTaskPo.setType(rs.getBoolean("type"));
        inviteCardTaskPo.setCreateTime(rs.getTimestamp("create_time"));
        inviteCardTaskPo.setUpdateTime(rs.getTimestamp("update_time"));
        inviteCardTaskPo.setOwnerOpenId(rs.getString("owner_open_id"));
        inviteCardTaskPo.setForcePush(rs.getBoolean("focus_push"));
        inviteCardTaskPo.setQrcodeUrl(rs.getString("wechat_url"));
        return inviteCardTaskPo;
    }

    private JdbcQuerySqlParamsBo getListQuery(List<String> appIds, Integer type) {
        StringBuilder sql = new StringBuilder("app_id in (");
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < appIds.size(); ++i) {
            if (i < appIds.size() - 1) {
                sql.append(" ?, ");
            } else {
                sql.append(" ?) ");
            }
            params.add(appIds.get(i));
        }
        if (type == 1) {
            sql.append(" and type=1 ");
        } else if (type == 2) {
            sql.append(" and type=0 ");
        }
        JdbcQuerySqlParamsBo paramsBo = new JdbcQuerySqlParamsBo();
        paramsBo.setSql(sql.toString());
        paramsBo.setParams(params);
        log.info("getListQuery: sql: {}, params: {}", (Object)sql.toString(), (Object)gson.toJson(params));
        return paramsBo;
    }

    private List<GongzhonghaoReplyContentPo> buildContents(String content) {
        ArrayList<GongzhonghaoReplyContentPo> list = new ArrayList<GongzhonghaoReplyContentPo>();
        JSONArray jsonArray = JSONObject.parseArray((String)content);
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add((GongzhonghaoReplyContentPo)gson.fromJson(jsonArray.get(i).toString(), GongzhonghaoReplyContentPo.class));
        }
        return list;
    }
}

