/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoGroupDao;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoGroupDaoImpl
extends AdDaoSupport
implements GongzhonghaoGroupDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoGroupDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer updateChatroomByGroupid(final String groupId, final Integer isSelect) {
        String sql = " UPDATE um.am_chatroom SET is_select = ? where group_id = ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("updateStatus - sql:{}, isSelect: {}, groupId: {}", (Object)" UPDATE um.am_chatroom SET is_select = ? where group_id = ?", (Object)isSelect);
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(" UPDATE um.am_chatroom SET is_select = ? where group_id = ?", 1);
                ps.setInt(1, isSelect);
                ps.setString(2, groupId);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: " + ret);
        return ret;
    }

    @Override
    public List<String> getChatroomIdByCategoryId(int categoryId) {
        StringBuilder sql = new StringBuilder("SELECT * FROM um.am_chatroom WHERE category_id = ? order by id");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(categoryId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        List list = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int i) throws SQLException {
                return rs.getString("group_id");
            }
        });
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public String getSelectChatroom(int categoryId, int isSelected) {
        StringBuilder sql = new StringBuilder("SELECT group_id FROM um.am_chatroom WHERE category_id = ? and is_select=?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(categoryId);
        params.add(isSelected);
        log.info("sql:{}, params:{} " + sql, (Object)gson.toJson(params));
        try {
            List list = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<String>(){

                public String mapRow(ResultSet rs, int i) throws SQLException {
                    return rs.getString("group_id");
                }
            });
            if (list != null && list.size() > 0) {
                return (String)list.get(0);
            }
        }
        catch (Exception ex) {
            log.info("\u6ca1\u6709\u4f18\u5148\u9009\u62e9\u7fa4: {}", (Throwable)ex);
        }
        return null;
    }

    @Override
    public boolean updateSelectChatroomSelect(final int categoryId, final int isSelected) {
        String sql = " UPDATE um.am_chatroom SET is_select = ? where category_id = ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("updateStatus - sql:{}, category_id: {}", (Object)" UPDATE um.am_chatroom SET is_select = ? where category_id = ?", (Object)categoryId);
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(" UPDATE um.am_chatroom SET is_select = ? where category_id = ?", 1);
                ps.setInt(1, isSelected);
                ps.setInt(2, categoryId);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: " + ret);
        return ret > 0;
    }
}

