/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoChatroomQrCodeDao;
import com.baijia.umgzh.dal.po.GongzhonghaoChatroomQrCodePo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoChatroomQrCodeDaoImpl
extends AdDaoSupport
implements GongzhonghaoChatroomQrCodeDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoChatroomQrCodeDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public int save(final GongzhonghaoChatroomQrCodePo chatroomQrCodePo) {
        String sql = "INSERT INTO um.am_gongzhonghao_chatroom_qrcode_media(group_id, url, name, app_id, media_id, create_time, wechat_url) VALUES(?, ?, ?, ?, ?, ?, ?) on duplicate key update url=values(url), name=values(name), media_id=values(media_id), create_time=values(create_time), wechat_url=values(wechat_url)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql: {}, chatroomQrCodePo: {}", (Object)"INSERT INTO um.am_gongzhonghao_chatroom_qrcode_media(group_id, url, name, app_id, media_id, create_time, wechat_url) VALUES(?, ?, ?, ?, ?, ?, ?) on duplicate key update url=values(url), name=values(name), media_id=values(media_id), create_time=values(create_time), wechat_url=values(wechat_url)", (Object)gson.toJson((Object)chatroomQrCodePo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO um.am_gongzhonghao_chatroom_qrcode_media(group_id, url, name, app_id, media_id, create_time, wechat_url) VALUES(?, ?, ?, ?, ?, ?, ?) on duplicate key update url=values(url), name=values(name), media_id=values(media_id), create_time=values(create_time), wechat_url=values(wechat_url)", 1);
                ps.setString(1, chatroomQrCodePo.getGroupId());
                ps.setString(2, chatroomQrCodePo.getUrl());
                ps.setString(3, chatroomQrCodePo.getName());
                ps.setString(4, chatroomQrCodePo.getAppId());
                ps.setString(5, chatroomQrCodePo.getMediaId());
                ps.setTimestamp(6, new Timestamp(chatroomQrCodePo.getCreateTime().getTime()));
                ps.setString(7, chatroomQrCodePo.getWechatUrl());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("result: {}", (Object)ret);
        return ret;
    }

    @Override
    public int update(final GongzhonghaoChatroomQrCodePo chatroomQrCodePo) {
        String sql = " UPDATE um.am_gongzhonghao_chatroom_qrcode_media SET group_id = ?, url = ?, name = ?,  app_id = ?, media_id = ?, create_time=?, wechat_url=? WHERE id = ? ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql: {}, chatroomQrCodePo: {}", (Object)" UPDATE um.am_gongzhonghao_chatroom_qrcode_media SET group_id = ?, url = ?, name = ?,  app_id = ?, media_id = ?, create_time=?, wechat_url=? WHERE id = ? ", (Object)gson.toJson((Object)chatroomQrCodePo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(" UPDATE um.am_gongzhonghao_chatroom_qrcode_media SET group_id = ?, url = ?, name = ?,  app_id = ?, media_id = ?, create_time=?, wechat_url=? WHERE id = ? ", 1);
                ps.setString(1, chatroomQrCodePo.getGroupId());
                ps.setString(2, chatroomQrCodePo.getUrl());
                ps.setString(3, chatroomQrCodePo.getName());
                ps.setString(4, chatroomQrCodePo.getAppId());
                ps.setString(5, chatroomQrCodePo.getMediaId());
                ps.setTimestamp(6, new Timestamp(chatroomQrCodePo.getCreateTime().getTime()));
                ps.setString(7, chatroomQrCodePo.getWechatUrl());
                ps.setInt(8, chatroomQrCodePo.getId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: {}", (Object)ret);
        return ret;
    }

    @Override
    public int saveOrUpdate(GongzhonghaoChatroomQrCodePo chatroomQrCodePo) {
        if (chatroomQrCodePo.getId() != null) {
            return this.update(chatroomQrCodePo);
        }
        return this.save(chatroomQrCodePo);
    }

    @Override
    public GongzhonghaoChatroomQrCodePo getQrCodePoByGroupId(String groupId, String appId) {
        String sql = "SELECT * FROM um.am_gongzhonghao_chatroom_qrcode_media WHERE group_id = ? and app_id = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(groupId);
        params.add(appId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            GongzhonghaoChatroomQrCodePo chatroomQrCodePo = (GongzhonghaoChatroomQrCodePo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoChatroomQrCodePo>(){

                public GongzhonghaoChatroomQrCodePo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoChatroomQrCodeDaoImpl.this.buildGongzhonghaoChatroomQrCodePo(rs);
                }
            });
            return chatroomQrCodePo;
        }
        catch (Exception e) {
            log.info("exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<GongzhonghaoChatroomQrCodePo> findChatroomQrCodePosByGroupIds(List<String> groupIds, String appId) {
        StringBuilder sql = new StringBuilder(" SELECT * FROM um.am_gongzhonghao_chatroom_qrcode_media WHERE app_id = ? and group_id IN ( ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        for (int i = 0; i < groupIds.size(); ++i) {
            if (i == groupIds.size() - 1) {
                sql.append(" ? ) ");
            } else {
                sql.append(" ? , ");
            }
            params.add(groupIds.get(i));
        }
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        List list = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<GongzhonghaoChatroomQrCodePo>(){

            public GongzhonghaoChatroomQrCodePo mapRow(ResultSet rs, int i) throws SQLException {
                return GongzhonghaoChatroomQrCodeDaoImpl.this.buildGongzhonghaoChatroomQrCodePo(rs);
            }
        });
        if (null == list || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public List<GongzhonghaoChatroomQrCodePo> findChatroomByGroupid(String groupId) {
        String sql = " SELECT * FROM um.am_gongzhonghao_chatroom_qrcode_media WHERE app_id = ? and group_id = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(groupId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        List list = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoChatroomQrCodePo>(){

            public GongzhonghaoChatroomQrCodePo mapRow(ResultSet rs, int i) throws SQLException {
                return GongzhonghaoChatroomQrCodeDaoImpl.this.buildGongzhonghaoChatroomQrCodePo(rs);
            }
        });
        if (null == list || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public int delChatroomQrCodePosByGroupId(List<String> groupIds, String appId) {
        StringBuilder sql = new StringBuilder(" DELETE FROM um.am_gongzhonghao_chatroom_qrcode_media WHERE app_id = ? and group_id in ( ");
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        for (int i = 0; i < groupIds.size(); ++i) {
            if (i == groupIds.size() - 1) {
                sql.append(" ? ) ");
            } else {
                sql.append(" ?, ");
            }
            params.add(groupIds.get(i));
        }
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        int count = this.getJdbcTemplate().update(sql.toString(), params.toArray());
        log.info("count: " + count);
        return count;
    }

    @Override
    public List<GongzhonghaoChatroomQrCodePo> getUnupdatedGroupInAWeek() {
        StringBuilder sql = new StringBuilder(" SELECT * FROM um.am_gongzhonghao_chatroom_qrcode_media WHERE url = '' OR  DATEDIFF (?, update_time) > 5 or media_id = ''");
        ArrayList<String> params = new ArrayList<String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String now = format.format(new Date(System.currentTimeMillis()));
        params.add(now);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        List list = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<GongzhonghaoChatroomQrCodePo>(){

            public GongzhonghaoChatroomQrCodePo mapRow(ResultSet rs, int i) throws SQLException {
                return GongzhonghaoChatroomQrCodeDaoImpl.this.buildGongzhonghaoChatroomQrCodePo(rs);
            }
        });
        if (null == list || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public List<GongzhonghaoChatroomQrCodePo> getGroupsByAccount(Integer accountId) {
        StringBuilder sql = new StringBuilder("select b.name name, b.group_id group_id, b.url url from um.am_chatroom a left join um.am_chatroom_qrcode b on a.group_id=b.group_id left join um.am_category c on a.category_id=c.id left join um.am_account d on c.account_id=d.id where d.id=?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(accountId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        List list = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<GongzhonghaoChatroomQrCodePo>(){

            public GongzhonghaoChatroomQrCodePo mapRow(ResultSet rs, int i) throws SQLException {
                GongzhonghaoChatroomQrCodePo chatroomQrCodePo = new GongzhonghaoChatroomQrCodePo();
                chatroomQrCodePo.setName(rs.getString("name"));
                chatroomQrCodePo.setGroupId(rs.getString("group_id"));
                chatroomQrCodePo.setUrl(rs.getString("url"));
                return chatroomQrCodePo;
            }
        });
        log.info(new Gson().toJson((Object)list));
        if (null == list || list.size() == 0) {
            return null;
        }
        return list;
    }

    private GongzhonghaoChatroomQrCodePo buildGongzhonghaoChatroomQrCodePo(ResultSet rs) throws SQLException {
        GongzhonghaoChatroomQrCodePo chatroomQrCodePo = new GongzhonghaoChatroomQrCodePo();
        chatroomQrCodePo.setId(rs.getInt("id"));
        chatroomQrCodePo.setGroupId(rs.getString("group_id"));
        chatroomQrCodePo.setUrl(rs.getString("url"));
        chatroomQrCodePo.setName(rs.getString("name"));
        chatroomQrCodePo.setAppId(rs.getString("app_id"));
        chatroomQrCodePo.setMediaId(rs.getString("media_id"));
        chatroomQrCodePo.setCreateTime(rs.getTimestamp("create_time"));
        chatroomQrCodePo.setUpdateTime(rs.getTimestamp("update_time"));
        chatroomQrCodePo.setWechatUrl(rs.getString("wechat_url"));
        return chatroomQrCodePo;
    }
}

