/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.def;

import com.baijia.umgzh.dal.def.BaseMessage;
import com.google.gson.Gson;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class WechatEventBody {
    public static final String RESP_MESSAGE_TYPE_TEXT = "text";
    public static final String RESP_MESSAGE_TYPE_MUSIC = "music";
    public static final String RESP_MESSAGE_TYPE_NEWS = "news";
    public static final String REQ_MESSAGE_TYPE_EVENT = "event";
    public static final String REQ_MESSAGE_TYPE_TEXT = "text";
    public static final String REQ_MESSAGE_TYPE_IMAGE = "image";
    public static final String REQ_MESSAGE_TYPE_LINK = "link";
    public static final String REQ_MESSAGE_TYPE_LOCATION = "location";
    public static final String REQ_MESSAGE_TYPE_VOICE = "voice";
    public static final String REQ_MESSAGE_TYPE_VIDEO = "video";
    public static final String REQ_MESSAGE_TYPE_SHORTVIDEO = "shortvideo";
    public static final String EVENT_TYPE_SUBSCRIBE = "subscribe";
    public static final String EVENT_TYPE_SCAN = "SCAN";
    public static final String EVENT_TYPE_UNSUBSCRIBE = "unsubscribe";
    public static final String EVENT_TYPE_CLICK = "CLICK";
    public static final String EVENT_TYPE_VIEW = "VIEW";
    public static final String QRSCENE_HEADER = "qrscene_";
    private String eventType;

    public static String createTextBody(String content, String fromUser, String toUser) {
        BaseMessage txmsg = new BaseMessage();
        txmsg.setContent(content);
        txmsg.setCreateTime(new Date().getTime());
        if (StringUtils.isNotBlank((CharSequence)fromUser)) {
            txmsg.setFromUserName(fromUser);
        }
        txmsg.setMsgType("text");
        if (StringUtils.isNotBlank((CharSequence)toUser)) {
            txmsg.setToUserName(toUser);
        }
        return WechatEventBody.textMessageToXml(txmsg);
    }

    private static String textMessageToXml(BaseMessage txmsg) {
        XStream xstream = WechatEventBody.getXStream();
        xstream.alias("xml", txmsg.getClass());
        return xstream.toXML((Object)txmsg);
    }

    private static XStream getXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new XppDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out){
                    boolean cdata;
                    {
                        super(x0);
                        this.cdata = true;
                    }

                    public void startNode(String name, Class clazz) {
                        super.startNode(name, clazz);
                    }

                    protected void writeText(QuickWriter writer, String text) {
                        if (this.cdata) {
                            writer.write("<![CDATA[");
                            writer.write(text);
                            writer.write("]]>");
                        } else {
                            writer.write(text);
                        }
                    }
                };
            }
        });
        return xstream;
    }

    public static void main(String[] args) {
        String eventResponseBody = WechatEventBody.createTextBody("from_callback", "fromUser", "toUser");
        System.out.println(new Gson().toJson((Object)eventResponseBody));
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }
}

