/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.support.web.dto.PageDto;
import com.baijia.umgzh.dal.bo.JdbcQuerySqlParamsBo;
import com.baijia.umgzh.dal.dao.GongzhonghaoStrategyDao;
import com.baijia.umgzh.dal.def.GongzhonghaoReplyStrategyType;
import com.baijia.umgzh.dal.po.GongzhonghaoStrategyPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoStrategyDaoImpl
extends AdDaoSupport
implements GongzhonghaoStrategyDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoStrategyDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public int save(final GongzhonghaoStrategyPo gongzhonghaoStrategyPo) {
        String sql = "INSERT INTO um.am_gongzhonghao_strategy(reply_type, keyword, permission, app_id, is_stop) VALUES(?, ?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}", (Object)"INSERT INTO um.am_gongzhonghao_strategy(reply_type, keyword, permission, app_id, is_stop) VALUES(?, ?, ?, ?, ?)", (Object)gson.toJson((Object)gongzhonghaoStrategyPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO um.am_gongzhonghao_strategy(reply_type, keyword, permission, app_id, is_stop) VALUES(?, ?, ?, ?, ?)", 1);
                ps.setInt(1, gongzhonghaoStrategyPo.getReplyType());
                ps.setString(2, gongzhonghaoStrategyPo.getKeyword());
                ps.setInt(3, gongzhonghaoStrategyPo.getPermission());
                ps.setString(4, gongzhonghaoStrategyPo.getAppId());
                ps.setInt(5, gongzhonghaoStrategyPo.getIsStop());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("keyHolder.getKey().intValue(): {}", (Object)keyHolder.getKey().intValue());
        return keyHolder.getKey().intValue();
    }

    @Override
    public int update(final GongzhonghaoStrategyPo gongzhonghaoStrategyPo) {
        String sql = "UPDATE um.am_gongzhonghao_strategy SET reply_type = ?, keyword = ?, permission = ?, app_id = ?, is_stop = ? WHERE id = ? ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params: {}", (Object)"UPDATE um.am_gongzhonghao_strategy SET reply_type = ?, keyword = ?, permission = ?, app_id = ?, is_stop = ? WHERE id = ? ", (Object)gson.toJson((Object)gongzhonghaoStrategyPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("UPDATE um.am_gongzhonghao_strategy SET reply_type = ?, keyword = ?, permission = ?, app_id = ?, is_stop = ? WHERE id = ? ", 1);
                ps.setInt(1, gongzhonghaoStrategyPo.getReplyType());
                ps.setString(2, gongzhonghaoStrategyPo.getKeyword());
                ps.setInt(3, gongzhonghaoStrategyPo.getPermission());
                ps.setString(4, gongzhonghaoStrategyPo.getAppId());
                ps.setInt(5, gongzhonghaoStrategyPo.getIsStop());
                ps.setInt(6, gongzhonghaoStrategyPo.getId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: {}", (Object)ret);
        return ret;
    }

    @Override
    public int delete(final Integer id) {
        String sql = "update um.am_gongzhonghao_strategy set is_stop=2 where id = ? ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("delete - sql:{}, params: {}", (Object)"update um.am_gongzhonghao_strategy set is_stop=2 where id = ? ", (Object)id);
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_gongzhonghao_strategy set is_stop=2 where id = ? ", 1);
                ps.setInt(1, id);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: {}, keyHolder: {} ", (Object)ret, (Object)keyHolder.getKey());
        return ret;
    }

    @Override
    public int saveOrUpdate(GongzhonghaoStrategyPo gongzhonghaoStrategyPo) {
        if (gongzhonghaoStrategyPo.getId() == null) {
            return this.save(gongzhonghaoStrategyPo);
        }
        GongzhonghaoStrategyPo gongzhonghaoStrategyPo1 = this.getGongzhonghaoStrategyPoById(gongzhonghaoStrategyPo.getId());
        if (gongzhonghaoStrategyPo1 == null) {
            return this.save(gongzhonghaoStrategyPo);
        }
        return this.update(gongzhonghaoStrategyPo);
    }

    @Override
    public GongzhonghaoStrategyPo getGongzhonghaoStrategyPoById(int id) {
        String sql = " SELECT * FROM um.am_gongzhonghao_strategy WHERE id = ?";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(id);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            GongzhonghaoStrategyPo gongzhonghaoStrategyPo = (GongzhonghaoStrategyPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoStrategyPo>(){

                public GongzhonghaoStrategyPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoStrategyDaoImpl.this.buildGongzhonghaoStrategyPo(rs);
                }
            });
            return gongzhonghaoStrategyPo;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public List<GongzhonghaoStrategyPo> getGongzhonghaoStrategyPos(List<String> appIdList, Integer replyType, String keyword, Integer permission, PageDto pageDto) {
        JdbcQuerySqlParamsBo bo = this.getGongzhonghaoListSqlParams(appIdList, replyType, keyword, permission, pageDto);
        StringBuilder sql = new StringBuilder("SELECT * ");
        sql.append(bo.getSql());
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(bo.getParams()));
        List list = this.getJdbcTemplate().query(sql.toString(), bo.getParams().toArray(), (RowMapper)new RowMapper<GongzhonghaoStrategyPo>(){

            public GongzhonghaoStrategyPo mapRow(ResultSet rs, int i) throws SQLException {
                return GongzhonghaoStrategyDaoImpl.this.buildGongzhonghaoStrategyPo(rs);
            }
        });
        return list;
    }

    @Override
    public Integer getGongzhonghaoStrategyPosCount(List<String> appIdList, Integer replyType, String keyword, Integer permission) {
        JdbcQuerySqlParamsBo bo = this.getGongzhonghaoListSqlParams(appIdList, replyType, keyword, permission, null);
        StringBuilder sql = new StringBuilder("SELECT count(*) ");
        sql.append(bo.getSql());
        log.info("sql: {}, params:{}", (Object)sql.toString(), (Object)gson.toJson(bo.getParams()));
        int count = (Integer)this.getJdbcTemplate().queryForObject(sql.toString(), bo.getParams().toArray(), Integer.class);
        return count;
    }

    @Override
    public List<GongzhonghaoStrategyPo> getGongzhonghaoStrategyByAppId(String app_id) {
        String sql = " SELECT * FROM um.am_gongzhonghao_strategy WHERE app_id = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(app_id);
        log.info("sql: {}, params:{}", (Object)sql, (Object)gson.toJson(params));
        List list = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoStrategyPo>(){

            public GongzhonghaoStrategyPo mapRow(ResultSet rs, int i) throws SQLException {
                return GongzhonghaoStrategyDaoImpl.this.buildGongzhonghaoStrategyPo(rs);
            }
        });
        return list;
    }

    @Override
    public Integer updateStrategyStatus(final Integer id, final Integer status) {
        String sql = "UPDATE um.am_gongzhonghao_strategy set is_stop= ? where id= ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, id:{}, status:{}", new Object[]{"UPDATE um.am_gongzhonghao_strategy set is_stop= ? where id= ?", id, status});
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("UPDATE um.am_gongzhonghao_strategy set is_stop= ? where id= ?", 1);
                ps.setInt(1, status);
                ps.setInt(2, id);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: {}", (Object)ret);
        return ret;
    }

    @Override
    public Integer stopGongzhonghaoStrategy(final String appId, final Integer status) {
        String sql = "UPDATE um.am_gongzhonghao_strategy set is_stop= ? where app_id= ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, appId:{}, status:{}", new Object[]{"UPDATE um.am_gongzhonghao_strategy set is_stop= ? where app_id= ?", appId, status});
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("UPDATE um.am_gongzhonghao_strategy set is_stop= ? where app_id= ?", 1);
                ps.setInt(1, status);
                ps.setString(2, appId);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: {}", (Object)ret);
        return ret;
    }

    private GongzhonghaoStrategyPo buildGongzhonghaoStrategyPo(ResultSet rs) throws SQLException {
        GongzhonghaoStrategyPo gongzhonghaoStrategyPo = new GongzhonghaoStrategyPo();
        gongzhonghaoStrategyPo.setId(rs.getInt("id"));
        gongzhonghaoStrategyPo.setReplyType(rs.getInt("reply_type"));
        gongzhonghaoStrategyPo.setKeyword(rs.getString("keyword"));
        gongzhonghaoStrategyPo.setPermission(rs.getInt("permission"));
        gongzhonghaoStrategyPo.setAppId(rs.getString("app_id"));
        gongzhonghaoStrategyPo.setIsStop(rs.getInt("is_stop"));
        return gongzhonghaoStrategyPo;
    }

    private JdbcQuerySqlParamsBo getGongzhonghaoListSqlParams(List<String> appIdList, Integer replyType, String keyword, Integer permission, PageDto pageDto) {
        StringBuilder sql = new StringBuilder("FROM um.am_gongzhonghao_strategy where is_stop in (0, 1) and app_id in ( ");
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < appIdList.size(); ++i) {
            params.add(appIdList.get(i));
            if (i == appIdList.size() - 1) {
                sql.append(" ?) ");
                continue;
            }
            sql.append(" ?, ");
        }
        if (permission != null) {
            if (1 == permission) {
                sql.append(" and permission in (?, ?) ");
                params.add(1);
                params.add(3);
            } else if (2 == permission) {
                sql.append(" and permission in (?, ?) ");
                params.add(2);
                params.add(3);
            } else {
                sql.append(" and permission = ? ");
                params.add(3);
            }
        }
        if (replyType != null) {
            sql.append(" and reply_type= ? ");
            params.add(replyType);
        }
        if (!StringUtils.isBlank((String)keyword)) {
            if (GongzhonghaoReplyStrategyType.getReplyType(keyword) == 2) {
                sql.append(" and reply_type = ? ");
                sql.append(" and keyword like ? ");
                params.add(2);
                params.add("%" + keyword + "%");
            } else {
                sql.append(" and reply_type = ? ");
                params.add(GongzhonghaoReplyStrategyType.getReplyType(keyword));
            }
        }
        sql.append(" order by update_time desc ");
        if (pageDto != null) {
            sql.append(" limit ?, ? ");
            params.add((pageDto.getPageNum() - 1) * pageDto.getPageSize());
            params.add(pageDto.getPageSize());
        }
        JdbcQuerySqlParamsBo bo = new JdbcQuerySqlParamsBo();
        bo.setSql(sql.toString());
        bo.setParams(params);
        return bo;
    }
}

