/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoOpenidGroupDao;
import com.baijia.umgzh.dal.po.GongzhonghaoOpenidGroupPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoOpenidGroupDaoImpl
extends AdDaoSupport
implements GongzhonghaoOpenidGroupDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoOpenidGroupDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer save(final GongzhonghaoOpenidGroupPo po) {
        String sql = "INSERT ignore INTO um.am_gongzhonghao_openid_group(app_id, openid, group_id, category_id) VALUES(?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("insert - sql:{}, params:{}", (Object)"INSERT ignore INTO um.am_gongzhonghao_openid_group(app_id, openid, group_id, category_id) VALUES(?, ?, ?, ?)", (Object)gson.toJson((Object)po));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT ignore INTO um.am_gongzhonghao_openid_group(app_id, openid, group_id, category_id) VALUES(?, ?, ?, ?)", 1);
                ps.setString(1, po.getAppId());
                ps.setString(2, po.getOpenId());
                ps.setString(3, po.getGroupId());
                ps.setInt(4, po.getCategoryId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return ret;
    }

    @Override
    public Integer update(GongzhonghaoOpenidGroupPo po) {
        return null;
    }

    @Override
    public Integer saveOrUpdate(GongzhonghaoOpenidGroupPo po) {
        return null;
    }

    @Override
    public List<GongzhonghaoOpenidGroupPo> getGroupsByOpenId(String appId, String openId) {
        String sql = "select * from um.am_gongzhonghao_openid_group where app_id = ? and openid = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        params.add(openId);
        log.info("sql: {}, appId: {}, openId: {}", new Object[]{sql, appId, openId});
        List groupPoList = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoOpenidGroupPo>(){

            public GongzhonghaoOpenidGroupPo mapRow(ResultSet rs, int i) throws SQLException {
                return GongzhonghaoOpenidGroupDaoImpl.this.buildGongzhonghaoOpenidGroupPo(rs);
            }
        });
        if (groupPoList == null || groupPoList.size() == 0) {
            return null;
        }
        return groupPoList;
    }

    @Override
    public GongzhonghaoOpenidGroupPo getGroupsByOpenIdAndCategoryId(String appId, String openId, Integer categoryId) {
        String sql = "select * from um.am_gongzhonghao_openid_group where app_id = ? and openid = ? and category_id=?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        params.add(openId);
        params.add(categoryId);
        log.info("sql: {}, appId: {}, openId: {}, categoryId: {}", new Object[]{sql, appId, openId, categoryId});
        try {
            GongzhonghaoOpenidGroupPo openidGroupPo = (GongzhonghaoOpenidGroupPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoOpenidGroupPo>(){

                public GongzhonghaoOpenidGroupPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoOpenidGroupDaoImpl.this.buildGongzhonghaoOpenidGroupPo(rs);
                }
            });
            return openidGroupPo;
        }
        catch (Exception ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Integer deleteUserGroupConn(String groupId, String openId) {
        String sql = String.format("delete from um.am_gongzhonghao_openid_group where openId='%s' and group_id='%s'", openId, groupId);
        log.info(sql);
        return this.getJdbcTemplate().update(sql);
    }

    @Override
    public Integer deleteUserGroupConnById(Integer id) {
        String sql = String.format("delete from um.am_gongzhonghao_openid_group where id=%d", id);
        log.info(sql);
        return this.getJdbcTemplate().update(sql);
    }

    private GongzhonghaoOpenidGroupPo buildGongzhonghaoOpenidGroupPo(ResultSet rs) throws SQLException {
        GongzhonghaoOpenidGroupPo po = new GongzhonghaoOpenidGroupPo();
        po.setId(rs.getInt("id"));
        po.setAppId(rs.getString("app_id"));
        po.setOpenId(rs.getString("openid"));
        po.setGroupId(rs.getString("group_id"));
        po.setCategoryId(rs.getInt("category_id"));
        return po;
    }
}

