/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.commons.lang.utils.date.DateUtils;
import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.AuthorizedGongzhonghaoDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoKefuReplyDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoMsgDao;
import com.baijia.umgzh.dal.dao.GongzhonghaoUserDao;
import com.baijia.umgzh.dal.po.GongzhonghaoMsgRecordPo;
import com.baijia.umgzh.dal.request.GongzhonghaoMsgRequest;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoMsgDaoImpl
extends AdDaoSupport
implements GongzhonghaoMsgDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoMsgDaoImpl.class);
    private static Gson gson = new Gson();
    @Resource
    private GongzhonghaoUserDao gongzhonghaoUserDao;
    @Resource
    private AuthorizedGongzhonghaoDao authorizedGongzhonghaoDao;
    @Resource
    private GongzhonghaoKefuReplyDao gongzhonghaoKefuReplyDao;

    @Override
    public Integer save(final GongzhonghaoMsgRequest msgRequest) {
        String sql = "insert into um.am_gongzhonghao_msg_record(openid, type, raw_content, time, gongzhonghao_id, app_id) values(?, ?, ?, ?, ?, ?)";
        log.info("sql: {}, params: {}", (Object)"insert into um.am_gongzhonghao_msg_record(openid, type, raw_content, time, gongzhonghao_id, app_id) values(?, ?, ?, ?, ?, ?)", (Object)gson.toJson((Object)msgRequest));
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("insert into um.am_gongzhonghao_msg_record(openid, type, raw_content, time, gongzhonghao_id, app_id) values(?, ?, ?, ?, ?, ?)", 1);
                ps.setString(1, msgRequest.getOpenid());
                ps.setInt(2, msgRequest.getType());
                ps.setString(3, msgRequest.getContent());
                ps.setTimestamp(4, msgRequest.getTime());
                ps.setString(5, msgRequest.getGongzhonghaoId());
                ps.setString(6, msgRequest.getAppId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    @Override
    public Integer getMsgCount(String appId) {
        String begin_date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(new Date().getTime() - 86400000L));
        String sql = "select count(*) from um.am_gongzhonghao_msg_record where app_id=? and create_time between ? and ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        params.add(begin_date + " 00:00:00");
        params.add(begin_date + " 23:59:59");
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            return (Integer)this.getJdbcTemplate().queryForObject(sql, params.toArray(), Integer.class);
        }
        catch (EmptyResultDataAccessException e) {
            return 0;
        }
    }

    @Override
    public List<GongzhonghaoMsgRecordPo> queryMessageRecords(String appId, Integer msgId, boolean isPickRecent, Integer maxSize, Date createDate) {
        log.info("request: appId: {}, msgId: {}, isPickRecent: {}, maxSize: {}, createDate: {}", new Object[]{appId, msgId, isPickRecent, maxSize, createDate});
        StringBuilder sql = new StringBuilder("select * from um.am_gongzhonghao_msg_record where app_id=? and id>? and create_time between ? and ? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        if (msgId == null) {
            params.add(0);
        } else {
            params.add(msgId);
        }
        if (createDate == null) {
            params.add(DateUtils.getBeginTimeOfDate((Date)new Date()));
            params.add(DateUtils.getEndTimeOfDate((Date)new Date()));
        } else {
            params.add(DateUtils.getBeginTimeOfDate((Date)createDate));
            params.add(DateUtils.getEndTimeOfDate((Date)createDate));
        }
        if (isPickRecent) {
            sql.append(" order by id desc limit ?");
        } else {
            sql.append(" order by id limit ?");
        }
        params.add(maxSize);
        log.info("sql: {}, params: {}", (Object)sql.toString(), (Object)gson.toJson(params));
        try {
            List messageRecordBos = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<GongzhonghaoMsgRecordPo>(){

                public GongzhonghaoMsgRecordPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoMsgDaoImpl.this.buileMsgRecordPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)messageRecordBos));
            if (messageRecordBos == null || messageRecordBos.size() == 0) {
                return null;
            }
            if (isPickRecent) {
                Collections.reverse(messageRecordBos);
            }
            return messageRecordBos;
        }
        catch (Exception ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void updateReplyContent(Integer id, Integer status) {
        String sql = String.format("update um.am_gongzhonghao_msg_record set status=%d where id=%d", status, id);
        log.info("sql: {}", (Object)sql);
        int ret = this.getJdbcTemplate().update(sql, new Object[0]);
    }

    @Override
    public GongzhonghaoMsgRecordPo getMsgInfoById(Integer id) {
        String sql = "select * from um.am_gongzhonghao_msg_record where id=?";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(id);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            GongzhonghaoMsgRecordPo msgRecordPo = (GongzhonghaoMsgRecordPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoMsgRecordPo>(){

                public GongzhonghaoMsgRecordPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoMsgDaoImpl.this.buileMsgRecordPo(rs);
                }
            });
            return msgRecordPo;
        }
        catch (EmptyResultDataAccessException ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<GongzhonghaoMsgRecordPo> queryMessageRecordsByRange(String appId, String openId, Integer msgId, Integer range) {
        StringBuilder sql = new StringBuilder("select * from um.am_gongzhonghao_msg_record where app_id=? and openid=?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        params.add(openId);
        if (range > 0) {
            sql.append(" and id >= ? limit ?");
            params.add(msgId);
            params.add(range + 1);
        } else {
            sql.append(" and id < ? order by id desc limit ?");
            params.add(msgId);
            params.add(0 - range);
        }
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            List messageRecordBos = this.getJdbcTemplate().query(sql.toString(), params.toArray(), (RowMapper)new RowMapper<GongzhonghaoMsgRecordPo>(){

                public GongzhonghaoMsgRecordPo mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return GongzhonghaoMsgDaoImpl.this.buileMsgRecordPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)messageRecordBos));
            if (messageRecordBos == null || messageRecordBos.size() == 0) {
                return null;
            }
            if (range < 0) {
                Collections.reverse(messageRecordBos);
            }
            return messageRecordBos;
        }
        catch (Exception ex) {
            log.info("exception: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Integer getLeftRecordCount(Integer chatRecordId, String appId, Date date) {
        String sql = "select count(*) from um.am_gongzhonghao_msg_record where app_id=? and id>? and create_time between ? and ?";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        if (chatRecordId == null) {
            params.add(0);
        } else {
            params.add(chatRecordId);
        }
        if (date == null) {
            params.add(DateUtils.getBeginTimeOfDate((Date)new Date()));
            params.add(DateUtils.getEndTimeOfDate((Date)new Date()));
        } else {
            params.add(DateUtils.getBeginTimeOfDate((Date)date));
            params.add(DateUtils.getEndTimeOfDate((Date)date));
        }
        log.info("sql: {}, params:{}", (Object)sql, (Object)gson.toJson(params));
        return (Integer)this.getJdbcTemplate().queryForObject(sql, params.toArray(), Integer.class);
    }

    private GongzhonghaoMsgRecordPo buileMsgRecordPo(ResultSet rs) throws SQLException {
        GongzhonghaoMsgRecordPo msgRecordPo = new GongzhonghaoMsgRecordPo();
        msgRecordPo.setId(rs.getInt("id"));
        msgRecordPo.setType(rs.getInt("type"));
        if (rs.getInt("type") == 2) {
            msgRecordPo.setType(3);
        }
        msgRecordPo.setRawContent(rs.getString("raw_content"));
        msgRecordPo.setTime(rs.getTimestamp("time"));
        msgRecordPo.setCreateTime(rs.getTimestamp("create_time"));
        msgRecordPo.setGongzhonghaoId(rs.getString("gongzhonghao_id"));
        msgRecordPo.setStatus(rs.getInt("status"));
        msgRecordPo.setAppId(rs.getString("app_id"));
        msgRecordPo.setOpenId(rs.getString("openid"));
        return msgRecordPo;
    }
}

