/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.GongzhonghaoInviteUserConnDao;
import com.baijia.umgzh.dal.po.GongzhonghaoInviteUserConnPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class GongzhonghaoInviteUserConnDaoImpl
extends AdDaoSupport
implements GongzhonghaoInviteUserConnDao {
    private static final Logger log = LoggerFactory.getLogger(GongzhonghaoInviteUserConnDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer save(final GongzhonghaoInviteUserConnPo userConnPo) {
        String sql = "INSERT INTO um.am_gongzhonghao_invite_user_conn(app_id, open_id, invited_open_id, status, nick_name, task_id) VALUES(?, ?, ?, ?, ?, ?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}", (Object)"INSERT INTO um.am_gongzhonghao_invite_user_conn(app_id, open_id, invited_open_id, status, nick_name, task_id) VALUES(?, ?, ?, ?, ?, ?)", (Object)gson.toJson((Object)userConnPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("INSERT INTO um.am_gongzhonghao_invite_user_conn(app_id, open_id, invited_open_id, status, nick_name, task_id) VALUES(?, ?, ?, ?, ?, ?)", 1);
                ps.setString(1, userConnPo.getAppId());
                ps.setString(2, userConnPo.getOpenId());
                ps.setString(3, userConnPo.getInvitedOpenId());
                ps.setInt(4, userConnPo.getStatus());
                ps.setString(5, userConnPo.getNickName());
                ps.setInt(6, userConnPo.getTaskId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("keyHolder.getKey().intValue(): " + keyHolder.getKey().intValue());
        return keyHolder.getKey().intValue();
    }

    @Override
    public Integer update(final GongzhonghaoInviteUserConnPo userConnPo) {
        String sql = "update um.am_gongzhonghao_invite_user_conn set nick_name= ? where app_id=? and open_id=? and invited_open_id=?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, params:{}", (Object)"update um.am_gongzhonghao_invite_user_conn set nick_name= ? where app_id=? and open_id=? and invited_open_id=?", (Object)gson.toJson((Object)userConnPo));
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_gongzhonghao_invite_user_conn set nick_name= ? where app_id=? and open_id=? and invited_open_id=?", 1);
                ps.setString(1, userConnPo.getNickName());
                ps.setString(2, userConnPo.getAppId());
                ps.setString(3, userConnPo.getOpenId());
                ps.setString(4, userConnPo.getInvitedOpenId());
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return ret;
    }

    @Override
    public Integer saveOrUpdate(GongzhonghaoInviteUserConnPo userConnPo) {
        if (this.getInfo(userConnPo.getAppId(), userConnPo.getOpenId(), userConnPo.getInvitedOpenId()) != null) {
            return this.update(userConnPo);
        }
        return this.save(userConnPo);
    }

    @Override
    public GongzhonghaoInviteUserConnPo getInfo(String appId, String openId, String invitedOpenId) {
        String sql = "select * from um.am_gongzhonghao_invite_user_conn where app_id = ? and open_id=? and invited_open_id=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        params.add(openId);
        params.add(invitedOpenId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            GongzhonghaoInviteUserConnPo inviteCardMediaPo = (GongzhonghaoInviteUserConnPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoInviteUserConnPo>(){

                public GongzhonghaoInviteUserConnPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoInviteUserConnDaoImpl.this.buileInviteMediaPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)inviteCardMediaPo));
            return inviteCardMediaPo;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Boolean updateStatus(final String appId, final String openId, final String invitedOpenId, final Integer status) {
        String sql = "update um.am_gongzhonghao_invite_user_conn set status = ? where open_id=? and app_id=? and invited_open_id=?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("sql:{}, appId:{}, openId: {}, invited_open_id: {}", new Object[]{"update um.am_gongzhonghao_invite_user_conn set status = ? where open_id=? and app_id=? and invited_open_id=?", appId, openId, invitedOpenId});
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement("update um.am_gongzhonghao_invite_user_conn set status = ? where open_id=? and app_id=? and invited_open_id=?", 1);
                ps.setInt(1, status);
                ps.setString(2, openId);
                ps.setString(3, appId);
                ps.setString(4, invitedOpenId);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        return true;
    }

    @Override
    public List<GongzhonghaoInviteUserConnPo> getUserListByNickname(String nickname, String appId) {
        String sql = "select * from um.am_gongzhonghao_invite_user_conn where nick_name=? and status=0 and app_id= ? order by create_time";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(nickname);
        params.add(appId);
        return this.getResult(sql, params);
    }

    @Override
    public List<GongzhonghaoInviteUserConnPo> getUserListByOpenId(String openId, String appId) {
        String sql = "select * from um.am_gongzhonghao_invite_user_conn where invited_open_id=? and status=0 and app_id= ? order by create_time desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(openId);
        params.add(appId);
        return this.getResult(sql, params);
    }

    @Override
    public Integer getInviteCount(String appId, String openId, Integer taskId) {
        String sql = "select count(*) from um.am_gongzhonghao_invite_user_conn where app_Id=? and open_id=? and task_id=? and status=1";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(appId);
        params.add(openId);
        params.add(taskId);
        return (Integer)this.getJdbcTemplate().queryForObject(sql, params.toArray(), Integer.class);
    }

    private List<GongzhonghaoInviteUserConnPo> getResult(String sql, List<Object> params) {
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            List inviteCardMediaPos = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<GongzhonghaoInviteUserConnPo>(){

                public GongzhonghaoInviteUserConnPo mapRow(ResultSet rs, int i) throws SQLException {
                    return GongzhonghaoInviteUserConnDaoImpl.this.buileInviteMediaPo(rs);
                }
            });
            if (null == inviteCardMediaPos || inviteCardMediaPos.size() == 0) {
                return null;
            }
            log.info("result: {}", (Object)gson.toJson((Object)inviteCardMediaPos));
            return inviteCardMediaPos;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    private GongzhonghaoInviteUserConnPo buileInviteMediaPo(ResultSet rs) throws SQLException {
        GongzhonghaoInviteUserConnPo inviteCardMediaPo = new GongzhonghaoInviteUserConnPo();
        inviteCardMediaPo.setAppId(rs.getString("app_id"));
        inviteCardMediaPo.setOpenId(rs.getString("open_id"));
        inviteCardMediaPo.setInvitedOpenId(rs.getString("invited_open_id"));
        inviteCardMediaPo.setStatus(rs.getInt("status"));
        inviteCardMediaPo.setTaskId(rs.getInt("task_id"));
        inviteCardMediaPo.setNickName(rs.getString("nick_name"));
        inviteCardMediaPo.setCreateTime(rs.getTimestamp("create_time"));
        inviteCardMediaPo.setUpdateTime(rs.getTimestamp("update_time"));
        return inviteCardMediaPo;
    }
}

