/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.umgzh.dal.dao.impl;

import com.baijia.robotcenter.dal.dao.AdDaoSupport;
import com.baijia.umgzh.dal.dao.AuthorizedGongzhonghaoDao;
import com.baijia.umgzh.dal.po.AuthorizedGongzhonghaoPo;
import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class AuthorizedGongzhonghaoDaoImpl
extends AdDaoSupport
implements AuthorizedGongzhonghaoDao {
    private static final Logger log = LoggerFactory.getLogger(AuthorizedGongzhonghaoDaoImpl.class);
    private static Gson gson = new Gson();

    @Override
    public Integer save(final AuthorizedGongzhonghaoPo gongzhonghaoPo) {
        String sql = " INSERT INTO um.am_authorized_gongzhonghao_info(account_id, app_id, refresh_token, func_info, nick_name, head_img, service_type, verify_type, gongzhonghao_id, alias, qrcode_url, is_del)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("\u4fdd\u5b58\u65b0\u7ed1\u5b9a\u516c\u4f17\u53f7: sql: {}, params: {}", (Object)" INSERT INTO um.am_authorized_gongzhonghao_info(account_id, app_id, refresh_token, func_info, nick_name, head_img, service_type, verify_type, gongzhonghao_id, alias, qrcode_url, is_del)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ", (Object)gson.toJson((Object)gongzhonghaoPo));
        try {
            int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement(" INSERT INTO um.am_authorized_gongzhonghao_info(account_id, app_id, refresh_token, func_info, nick_name, head_img, service_type, verify_type, gongzhonghao_id, alias, qrcode_url, is_del)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ", 1);
                    ps.setInt(1, gongzhonghaoPo.getAccountId());
                    ps.setString(2, gongzhonghaoPo.getAppId());
                    ps.setString(3, gongzhonghaoPo.getRefreshToken());
                    ps.setString(4, gongzhonghaoPo.getFuncInfo());
                    ps.setString(5, gongzhonghaoPo.getNickName());
                    ps.setString(6, gongzhonghaoPo.getHeadImg());
                    ps.setInt(7, gongzhonghaoPo.getServiceType());
                    ps.setInt(8, gongzhonghaoPo.getVerifyType());
                    ps.setString(9, gongzhonghaoPo.getGongzhonghaoId());
                    ps.setString(10, gongzhonghaoPo.getAlias());
                    ps.setString(11, gongzhonghaoPo.getQrcodeUrl());
                    ps.setInt(12, 0);
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            log.info("keyHolder.getKey().intValue(): {}", (Object)keyHolder.getKey().intValue());
            return keyHolder.getKey().intValue();
        }
        catch (Exception ex) {
            log.info("\u4fdd\u5b58\u65b0\u7ed1\u5b9a\u516c\u4f17\u53f7\u9519\u8bef: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Integer update(final AuthorizedGongzhonghaoPo gongzhonghaoPo) {
        String sql = "update um.am_authorized_gongzhonghao_info set account_id= ?, refresh_token=?, func_info=?, nick_name=?, head_img=?, service_type=?, verify_type=?, gongzhonghao_id=?, alias=?, qrcode_url=?, is_del=? where app_id = ?";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("\u4fdd\u5b58\u65b0\u7ed1\u5b9a\u516c\u4f17\u53f7: sql: {}, params: {}", (Object)"update um.am_authorized_gongzhonghao_info set account_id= ?, refresh_token=?, func_info=?, nick_name=?, head_img=?, service_type=?, verify_type=?, gongzhonghao_id=?, alias=?, qrcode_url=?, is_del=? where app_id = ?", (Object)gson.toJson((Object)gongzhonghaoPo));
        try {
            int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                    PreparedStatement ps = connection.prepareStatement("update um.am_authorized_gongzhonghao_info set account_id= ?, refresh_token=?, func_info=?, nick_name=?, head_img=?, service_type=?, verify_type=?, gongzhonghao_id=?, alias=?, qrcode_url=?, is_del=? where app_id = ?", 1);
                    ps.setInt(1, gongzhonghaoPo.getAccountId());
                    ps.setString(2, gongzhonghaoPo.getRefreshToken());
                    ps.setString(3, gongzhonghaoPo.getFuncInfo());
                    ps.setString(4, gongzhonghaoPo.getNickName());
                    ps.setString(5, gongzhonghaoPo.getHeadImg());
                    ps.setInt(6, gongzhonghaoPo.getServiceType());
                    ps.setInt(7, gongzhonghaoPo.getVerifyType());
                    ps.setString(8, gongzhonghaoPo.getGongzhonghaoId());
                    ps.setString(9, gongzhonghaoPo.getAlias());
                    ps.setString(10, gongzhonghaoPo.getQrcodeUrl());
                    ps.setInt(11, 0);
                    ps.setString(12, gongzhonghaoPo.getAppId());
                    return ps;
                }
            }, (KeyHolder)keyHolder);
            log.info("ret: {}", (Object)ret);
            return ret;
        }
        catch (Exception ex) {
            log.error("\u4fdd\u5b58\u65b0\u7ed1\u5b9a\u516c\u4f17\u53f7\u9519\u8bef: {}", (Throwable)ex);
            return null;
        }
    }

    @Override
    public Integer saveOrUpdate(AuthorizedGongzhonghaoPo gongzhonghaoPo) {
        if (this.getAuthorizedGongzhonghaoByAppid(gongzhonghaoPo.getAppId()) == null) {
            return this.save(gongzhonghaoPo);
        }
        return this.update(gongzhonghaoPo);
    }

    @Override
    public AuthorizedGongzhonghaoPo getAuthorizedGongzhonghaoByAppid(String appid) {
        String sql = " SELECT * FROM um.am_authorized_gongzhonghao_info WHERE app_id = ? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appid);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            AuthorizedGongzhonghaoPo gongzhonghaoPo = (AuthorizedGongzhonghaoPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<AuthorizedGongzhonghaoPo>(){

                public AuthorizedGongzhonghaoPo mapRow(ResultSet rs, int i) throws SQLException {
                    return AuthorizedGongzhonghaoDaoImpl.this.buildAuthorizedGongzhonghaoPo(rs);
                }
            });
            return gongzhonghaoPo;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Integer deleteAuthorizedGongzhonghaoByAppid(final String appid) {
        String sql = " UPDATE um.am_authorized_gongzhonghao_info SET is_del= ? WHERE app_id = ? ";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        log.info("updateStatus - sql:{}, appid: {}", (Object)" UPDATE um.am_authorized_gongzhonghao_info SET is_del= ? WHERE app_id = ? ", (Object)appid);
        int ret = this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(" UPDATE um.am_authorized_gongzhonghao_info SET is_del= ? WHERE app_id = ? ", 1);
                ps.setInt(1, 1);
                ps.setString(2, appid);
                return ps;
            }
        }, (KeyHolder)keyHolder);
        log.info("ret: {}", (Object)ret);
        return ret;
    }

    @Override
    public List<AuthorizedGongzhonghaoPo> getGongzhonghaoAccountList(Integer accountId) {
        String sql = "select * from um.am_authorized_gongzhonghao_info where account_id = ? and is_del=0 and verify_type<>-1";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(accountId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            List accountPoList = this.getJdbcTemplate().query(sql, params.toArray(), (RowMapper)new RowMapper<AuthorizedGongzhonghaoPo>(){

                public AuthorizedGongzhonghaoPo mapRow(ResultSet rs, int i) throws SQLException {
                    return AuthorizedGongzhonghaoDaoImpl.this.buildAuthorizedGongzhonghaoPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)accountPoList));
            return accountPoList;
        }
        catch (EmptyResultDataAccessException e) {
            log.info("exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public AuthorizedGongzhonghaoPo getLatestNotVerifyGongzhonghao(Integer accountId) {
        String sql = "select * from um.am_authorized_gongzhonghao_info where account_id = ? and is_del=0 and verify_type=-1 and TIMESTAMPDIFF(HOUR, update_time, now()) < 1 order by update_time desc limit 1";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(accountId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            AuthorizedGongzhonghaoPo accountPo = (AuthorizedGongzhonghaoPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<AuthorizedGongzhonghaoPo>(){

                public AuthorizedGongzhonghaoPo mapRow(ResultSet rs, int i) throws SQLException {
                    return AuthorizedGongzhonghaoDaoImpl.this.buildAuthorizedGongzhonghaoPo(rs);
                }
            });
            log.info("result: {}", (Object)gson.toJson((Object)accountPo));
            return accountPo;
        }
        catch (EmptyResultDataAccessException e) {
            log.info("exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getOneAppIdByAccountId(Integer accountId) {
        String sql = "select app_id from um.am_authorized_gongzhonghao_info where account_id = ? order by id limit 1";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(accountId);
        log.info("sql: {}, params: {}", (Object)sql, params);
        try {
            return (String)this.getJdbcTemplate().queryForObject(sql, params.toArray(), String.class);
        }
        catch (EmptyResultDataAccessException e) {
            log.info("exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public AuthorizedGongzhonghaoPo getInfoByAppid(String appId) {
        String sql = "select * from um.am_authorized_gongzhonghao_info where app_id=? and is_del=0 limit 1";
        ArrayList<String> params = new ArrayList<String>();
        params.add(appId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            AuthorizedGongzhonghaoPo accountPo = (AuthorizedGongzhonghaoPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<AuthorizedGongzhonghaoPo>(){

                public AuthorizedGongzhonghaoPo mapRow(ResultSet rs, int i) throws SQLException {
                    return AuthorizedGongzhonghaoDaoImpl.this.buildAuthorizedGongzhonghaoPo(rs);
                }
            });
            return accountPo;
        }
        catch (EmptyResultDataAccessException e) {
            log.info("exception: {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public AuthorizedGongzhonghaoPo getInfoByGongzhonghaoId(String gongzhonghaoId) {
        String sql = "select * from um.am_authorized_gongzhonghao_info where gognzhonghao_id=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(gongzhonghaoId);
        log.info("sql: {}, params: {}", (Object)sql, (Object)gson.toJson(params));
        try {
            AuthorizedGongzhonghaoPo accountPo = (AuthorizedGongzhonghaoPo)this.getJdbcTemplate().queryForObject(sql, params.toArray(), (RowMapper)new RowMapper<AuthorizedGongzhonghaoPo>(){

                public AuthorizedGongzhonghaoPo mapRow(ResultSet rs, int i) throws SQLException {
                    return AuthorizedGongzhonghaoDaoImpl.this.buildAuthorizedGongzhonghaoPo(rs);
                }
            });
            return accountPo;
        }
        catch (EmptyResultDataAccessException e) {
            log.info("exception: {}", (Throwable)e);
            return null;
        }
    }

    private AuthorizedGongzhonghaoPo buildAuthorizedGongzhonghaoPo(ResultSet rs) throws SQLException {
        AuthorizedGongzhonghaoPo gongzhonghaoPo = new AuthorizedGongzhonghaoPo();
        gongzhonghaoPo.setAccountId(rs.getInt("account_id"));
        gongzhonghaoPo.setAppId(rs.getString("app_id"));
        gongzhonghaoPo.setRefreshToken(rs.getString("refresh_token"));
        gongzhonghaoPo.setFuncInfo(rs.getString("func_info"));
        gongzhonghaoPo.setNickName(rs.getString("nick_name"));
        gongzhonghaoPo.setHeadImg(rs.getString("head_img"));
        gongzhonghaoPo.setServiceType(rs.getInt("service_type"));
        gongzhonghaoPo.setVerifyType(rs.getInt("verify_type"));
        gongzhonghaoPo.setGongzhonghaoId(rs.getString("gongzhonghao_id"));
        gongzhonghaoPo.setAlias(rs.getString("alias"));
        gongzhonghaoPo.setQrcodeUrl(rs.getString("qrcode_url"));
        gongzhonghaoPo.setIsDel(rs.getInt("is_del"));
        return gongzhonghaoPo;
    }
}

