package com.baijia.tianxiao.util;




import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;


/**
 * 
 * ExcelUtils
 * Description: 
 * @author zhenyujian
 * Date: 2015年7月31日 上午12:16:27
 * 
 * @version 1.0.0
 * 
 */
public class ExcelUtils {
	
	/**
	 * ParamType
	 * Description: 参数 数据类型 枚举 
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:27:17
	 */
	public enum ParamType {
		type_int,
		type_double,
		type_string,
		type_date
	}
	
	/**
	 * Description: 为已知行、列的单元格填充指定类型的数值 并填充指定的样式
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:20:36
	 * @param sheet
	 * @param rowNo
	 * @param cellNo
	 * @param cellStyle
	 * @param value
	 * @param paramType 
	 * @return void
	 */
	public static XSSFCell fillTheXSSFCellWithValue(XSSFSheet sheet, int rowNo, int cellNo,CellStyle cellStyle, Object value, ParamType paramType){
		XSSFRow row = sheet.getRow(rowNo);
		if(row == null){
			row = sheet.createRow(rowNo);
		}
		XSSFCell cell= row.createCell(cellNo);
		if(cellStyle != null){
			cell.setCellStyle(cellStyle);
		}
		if(value != null){
			if(paramType == ParamType.type_int){
				cell.setCellValue((int)value);
			}else if(paramType == ParamType.type_double){
				cell.setCellValue((double)value);
			}else if(paramType == ParamType.type_string){
				cell.setCellValue((String)value);
			}else if(paramType == ParamType.type_date){
				cell.setCellValue((Date)value);
			}else{
				cell.setCellValue("");
			}
		}else{
			cell.setCellValue("");
		}
		return cell;
	}
	
	
	/**
	 * Description: 为已知行、列的单元格填充int类型的数值 并填充指定的样式
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:20:40
	 * @return void
	 */
	public static XSSFCell fillTheXSSFCellWithIntValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Integer value){
		return fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_int);
	}
	
	/**
	 * Description: 为已知行、列的单元格填充double类型的数值 并填充指定的样式
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:20:40
	 * @return void
	 */
	public static XSSFCell fillTheXSSFCellWithDoubleValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Double value){
		return fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_double);
	}
	
	/**
	 * Description: 为已知行、列的单元格填充String类型的数值 并填充指定的样式
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:20:43
	 * @return void
	 */
	public static XSSFCell fillTheXSSFCellWithStringValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, String value){
		return fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_string);
	}
	
	
	/**
	 * Description: 为已知行、列的单元格填充Date类型的数值 并填充指定的样式
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:20:47 
	 * @return void
	 */
	public static XSSFCell fillTheXSSFCellWithDateValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Date value){
		return fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_date);
	}

	
	/**
	 * Description: 为单元格样式设置 border样式及颜色
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:21:14
	 * @param cellStyle
	 * @param borderStyle
	 * @param borderColorIndex 
	 * @return void
	 */
	public static void fillCellStyleWithFullBorder(XSSFCellStyle cellStyle, short borderStyle, short borderColorIndex){
		cellStyle.setBorderTop(borderStyle);
		cellStyle.setTopBorderColor(borderColorIndex);
		
		cellStyle.setBorderRight(borderStyle);
		cellStyle.setRightBorderColor(borderColorIndex);
		
		cellStyle.setBorderBottom(borderStyle);
		cellStyle.setBottomBorderColor(borderColorIndex);
		
		cellStyle.setBorderLeft(borderStyle);
		cellStyle.setLeftBorderColor(borderColorIndex);
	}
	
	
	/**
	 * Description: 为单元格样式设置 背景颜色
	 * @author zhenyujian
	 * Date: 2015年7月31日 上午12:21:17
	 * @param cellStyle
	 * @param fillForegroundColor
	 * @param fillPattern 
	 * @return void
	 */
	public static void fillCellStyleWithBGColor(XSSFCellStyle cellStyle, XSSFColor fillForegroundColor, short fillPattern){
		cellStyle.setFillForegroundColor(fillForegroundColor);
		cellStyle.setFillPattern(fillPattern);
	}
	
	
	/**
	 * Description: 返回含有样式行 每列数据格式的map
	 * @author zhenyujian
	 * Date: 2015年7月22日 下午6:01:34
	 * @param sheet
	 * @param demoRowNo
	 * @param demoCellStartNo
	 * @param demoCellEndNo
	 *  
	 * @return Map<Integer,Short> (列号,数据格式)
	 */
	public static Map<Integer,CellInfo> getCellInfoMap(XSSFSheet sheet, int demoRowNo, int demoCellStartNo, int demoCellEndNo){
		Map<Integer,CellInfo> map = new HashMap<Integer,CellInfo>();
		XSSFCell cell;
		CellInfo cellInfo;
		for(; demoCellStartNo<=demoCellEndNo;demoCellStartNo++){
			System.out.println(sheet.getLastRowNum());
			System.out.println(sheet.getRow(demoRowNo));
			
			cell = sheet.getRow(demoRowNo).getCell(demoCellStartNo);
			if(cell != null){
				cellInfo = new CellInfo();
				cellInfo.setDataFormat(cell.getCellStyle().getDataFormat());
				cellInfo.setAlignment(cell.getCellStyle().getAlignment());
				map.put(demoCellStartNo, cellInfo);
			}
		}
		return map;
	}
	
	public static XSSFCellStyle decorateStyleWithDataFormatMap(int cellNo, XSSFCellStyle cellStyle, Map<Integer,CellInfo> dataFormatMap){
		XSSFCellStyle style = (XSSFCellStyle)cellStyle.clone();
		if(dataFormatMap.get(cellNo) != null){
			CellInfo cellInfo = dataFormatMap.get(cellNo);
			if(cellInfo != null){
				if(cellInfo.getDataFormat() != null){
					style.setDataFormat(cellInfo.getDataFormat());
				}
				if(cellInfo.getAlignment() != null){
					style.setAlignment(cellInfo.getAlignment());
				}
			}
		}
		return style;
	}
	
	
	/**
	 * 
	 * CellInfo
	 * Description: cell样式信息
	 * @author zhenyujian
	 * Date: 2015年7月22日 下午8:21:40
	 * 
	 * @version 1.0.0
	 * 
	 */
	public static class CellInfo{
		Short dataFormat;//数据格式
		Short alignment; //左右对齐
		
		public CellInfo(){}
		public CellInfo(Short dataFormat, Short alignment){
			this.dataFormat = dataFormat;
			this.alignment = alignment;
		}
		
		public Short getDataFormat() {
			return dataFormat;
		}
		public void setDataFormat(Short dataFormat) {
			this.dataFormat = dataFormat;
		}
		
		public Short getAlignment() {
			return alignment;
		}
		public void setAlignment(Short alignment) {
			this.alignment = alignment;
		}
	}
	
	/**
	 * @Description     : 判断单元格是否不存在内容
	 *
	 * @Author          : zhenyujian
	 * @CreationDate    : 2015年7月31日 下午6:19:51
	 * @Modifier        : 
	 * @ModificationDate: 
	 *
	 * @Return boolean
	 */
	public static boolean isCellEmpty(XSSFRow row,int cellNo){
		XSSFCell cell = row.getCell(cellNo);
		if(cell==null || cell.getRawValue()==null ||cell.getRawValue().equals("")){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * @Description     :指定行是否不存在单元格或者含有空值 
	 *
	 * @Author          : zhenyujian
	 * @CreationDate    : 2015年7月31日 上午11:11:50
	 * @Modifier        : 
	 * @ModificationDate: 
	 *
	 * @Return boolean
	 */
	public static boolean isRowContainsEmpty(XSSFRow row, int startCellNo, int endCellNo){
		
		for(int i=startCellNo; i<=endCellNo; i++){
			XSSFCell cell = row.getCell(i);
			if(cell==null || cell.getRawValue()==null ||cell.getRawValue().equals("")){
				return true;
			}
		}
		return false;
	}
	
	/**
	 * @Description     : 将excel单元格的类型转换为字符串  取值时统一使用.getStringCellValue() 避免type转换错误
	 *
	 * @Author          : zhenyujian
	 * @CreationDate    : 2015年7月27日 上午11:00:01
	 * @Modifier        : 
	 * @ModificationDate: 
	 *
	 * @Return void
	 */
	public static void cellTypeToString(XSSFRow row, int startCellNo, int endCellNo){
		for(int i=startCellNo; i<=endCellNo; i++){
			row.getCell(i).setCellType(Cell.CELL_TYPE_STRING);
		}
	}
	
	public static XSSFCellStyle getYellowBGStyle(XSSFWorkbook workbook){
	    XSSFCellStyle yellowStyle = workbook.createCellStyle();
	    yellowStyle.setWrapText(true);
	    yellowStyle.setLocked(false);
	    yellowStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	    yellowStyle.setFillForegroundColor(new XSSFColor(Color.YELLOW));
	    return yellowStyle;
	}
	
	public static XSSFCellStyle getWhitewBGStyle(XSSFWorkbook workbook){
	    XSSFCellStyle whiteStyle = workbook.createCellStyle();
	    whiteStyle.setWrapText(true);
	    whiteStyle.setLocked(false);
	    whiteStyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	    whiteStyle.setFillForegroundColor(new XSSFColor(Color.WHITE));
	    return whiteStyle;
	}
	
    public static void setHSSFStringPrompt(XSSFSheet sheet, String promptTitle, String promptContent, int firstRow,
        int endRow, int firstCol, int endCol) {
        DataValidationHelper helper = new XSSFDataValidationHelper((XSSFSheet) sheet);
        DataValidationConstraint constraintDecimal = new XSSFDataValidationConstraint(
            DataValidationConstraint.ValidationType.TEXT_LENGTH, DataValidationConstraint.OperatorType.LESS_THAN, "30");
        CellRangeAddressList regionDecimal = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DataValidation validationDecimal = helper.createValidation(constraintDecimal, regionDecimal);
        validationDecimal.createPromptBox(promptTitle, promptContent);
        validationDecimal.setShowPromptBox(true);
        sheet.addValidationData(validationDecimal); 
    }
	
}