package com.baijia.tianxiao.util;

import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;

import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import lombok.Data;

public class CourseSmsTokenUtil {

    public static final int TOKEN_VERSION = 1;

    @Data
    public static class SmsToken {
        private Date ts;

        private Long orgId;

        private Map<String, Object> params = new HashMap<>();

        private Integer version;

        public void put(String key, Object value) {
            params.put(key, value);
        }
    }

    // public static String encodeToken(OrgCourseSms sms) throws Exception {
    // Preconditions.checkArgument(sms != null, "smsCourse is null");
    // Map<String, Object> token = new HashMap<>();
    // token.put("orgId", sms.getOrgId());
    // token.put("courseId", sms.getCourseId());
    // token.put("id", sms.getId());
    //
    // if (UserRole.STUDENT.getRole() == sms.getUserRole()) {
    // token.put("studentId", sms.getStudentId());
    // } else if (UserRole.TEACHER.getRole() == sms.getUserRole()) {
    // token.put("teacherId", sms.getUserId());
    // }
    // return encodeToken(token);
    // }

    public static String encodeToken(Map<String, Object> params) throws Exception {
        return encodeToken(params, (Long) params.get("orgId"));
    }

    public static String encodeToken(Map<String, Object> params, Long orgId) throws Exception {
        return encodeExpireToken(params, orgId, DateUtil.getDiffDateTime(new Date(), 2));
    }

    public static String encodeExpireToken(Map<String, Object> params, Long orgId, Date expireDate) throws Exception {
        Preconditions.checkArgument(params != null, "params is null");
        SmsToken token = new SmsToken();
        token.setOrgId(orgId);
        token.getParams().putAll(params);
        token.setTs(expireDate);
        token.setVersion(TOKEN_VERSION);
        return EncryptUtils.base64EncodeStrWithFactor(token);
    }

    public static SmsToken decodeToken(String token) throws Exception {
        if (StringUtils.isBlank(token)) {
            return null;
        }
        String jsonStr = EncryptUtils.strDecode(token);
        return JacksonUtil.str2Obj(jsonStr, SmsToken.class);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(encodeToken(Maps.<String, Object> newHashMap(), 3618l));

        String token =
            "BoEoenkoQDg7Pjo5Oz86Pj9BPjk1K3h7cFNuLEQ-OjxBNy17bH5teX8uRogvfH90VnIwSEI-P0U7MYZ0cnhxhFGAgFp1M0sziIpCdEV3S0RMSUV5SkhFR0ZENpJBN4t6h4l_hYQ4UEiU";
        SmsToken t = decodeToken(token);
        System.out.println(t);
        
        String token1 =
                "C34ld3YlPTQ3OjY7Nzg9NDY0ODkwJnN3bE5pJz85PTo1MSh2Z3hnc3koQIEodnluUGspQTs_PDc0Kn9ta3BpfEl4eFJtK0MrgIE5azxuQztDQDxwQT47PTw7LYg3LYFwfX50enouRj2J";
            SmsToken t1 = decodeToken(token1);
            System.out.println(t1);
    }
}
