
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.imageio.ImageIO;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Preconditions;

/**
 * @title ImageUtils
 * @desc TODO
 * @author cxm
 * @date 2016年2月26日
 * @version 1.0
 */
@Slf4j
public class OrgQrImageUtils {

    private static final int DEFAULT_IMAGE_WIDTH = 880;

    private static final int DEFAULT_IMAGE_HEIGHT = 320;

    public static Image getImageFromUrl(String url) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(url), "image url can not be null");
        URL imageUrl = new URL(url);
        InputStream in = null;
        InputStream in4Ex = null;
        
        try {
            in = imageUrl.openStream();
            return ImageIO.read(in);
        } catch(javax.imageio.IIOException e){
        	imageUrl = new URL("http://img.gsxservice.com/23036387_sfu8bjal.png");
        	in4Ex = imageUrl.openStream();
        	return ImageIO.read(in4Ex);
        } catch(Exception e){
        	log.error(url,e);
        	throw e;
        }finally {
        	if(in!=null){
        		IOUtils.closeQuietly(in);
        	}
        	if(in4Ex!=null){
        		IOUtils.closeQuietly(in4Ex);
        	}
        }
    }

    public static Image readImageFromFile(String fileName) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(fileName), "image file name can not be null");
        File imgFile = new File(fileName);
        if (!imgFile.exists()) {
            throw new FileNotFoundException(fileName + " is not exist");
        }
        return ImageIO.read(imgFile);
    }

    public static Image loadImage(String fileName) throws IOException {
        Preconditions.checkArgument(StringUtils.isNoneBlank(fileName), "image file name can not be null");
        InputStream in = null;
        try {
            in = OrgQrImageUtils.class.getClassLoader().getResourceAsStream(fileName);
            Preconditions.checkNotNull(in, "can not read file:" + fileName);
            return ImageIO.read(in);
        } finally {
            IOUtils.closeQuietly(in);
        }
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img = generateOrgQrFingerPrintImg("机构名称", "http://test-img.gsxservice.com/429623_wvy1l1ie.jpg",
            "1234567 转 666", "微软雅黑","http://wx.qlogo.cn/mmopen/VHU8bI7BOJCOrCdj43nwWEibME0liaPg2sIf9hZ8SnTrttgbOJGOQiao3AHq6ZzATbk177IagO7HIWZwhBnHVib9YR7dibS3nmDLy/0");

        File file = new File("/Users/zhenyujian/Desktop/image.jpg");
        ImageIO.write(img, "png", file);
    }

    public static BufferedImage generateOrgQrFingerPrintImg(String orgName, String qrUrl, String telStr, String weixin, String weixinHeadImgUrl) throws IOException {
    	if(StringUtils.isBlank(weixinHeadImgUrl)){
    		weixinHeadImgUrl = "http://img.gsxservice.com/23036387_sfu8bjal.png";
    	}
    	
        Preconditions.checkArgument(StringUtils.isNoneBlank(orgName), "orgName can not be null");
        Preconditions.checkArgument(StringUtils.isNoneBlank(qrUrl), "qrUrl can not be null");
        //Preconditions.checkArgument(StringUtils.isNoneBlank(extension), "extension can not be null");
        Preconditions.checkArgument(StringUtils.isNoneBlank(weixin), "weixin can not be null");
        
        
        

        Image qrImg = getImageFromUrl(qrUrl);
        Image weixinHeadImg = getImageFromUrl(weixinHeadImgUrl);
        String weixinStr = "公众号 ：" + weixin;
        telStr = "电   话 ："+telStr;

        Font font = new Font("微软雅黑", Font.PLAIN, 20);
        BufferedImage bi = new BufferedImage(DEFAULT_IMAGE_WIDTH, DEFAULT_IMAGE_HEIGHT, BufferedImage.TYPE_USHORT_565_RGB);
        Graphics2D g2 = (Graphics2D) bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setBackground(Color.WHITE);
        g2.fillRect(0, 0, DEFAULT_IMAGE_WIDTH, DEFAULT_IMAGE_HEIGHT);
        g2.setPaint(Color.BLACK);
        g2.setFont(font);

        int x = 100;
        int y = DEFAULT_IMAGE_HEIGHT/2;

        //公众号头像
        Image a = makeRoundedCorner((BufferedImage)weixinHeadImg,1000);
        g2.drawImage(a,  200, 40 ,130,130,null);
        //微信号
        g2.drawString(weixinStr,  x,  y / 2 + 129);
        //电话
        g2.drawString(telStr,  x,  y / 2 + 160);
        //尾语
        g2.drawString("长按右侧二维码 , 关注我们。",  x,  y / 2 + 190);
        
        //二维码
        g2.drawImage(qrImg, DEFAULT_IMAGE_WIDTH-280-x, 20, 280, 280, null);
        
        return bi;

    }
    
    
    public static BufferedImage setClip(BufferedImage srcImage, int radius){
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        Graphics2D gs = image.createGraphics();

        gs.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gs.setClip(new RoundRectangle2D.Double(0, 0, width, height, radius, radius));
        gs.drawImage(srcImage, 0, 0, null);
        gs.dispose();
        return image;
    }
    
    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {  
        int w = image.getWidth();  
        int h = image.getHeight();  
        BufferedImage output = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);  
        Graphics2D g2 = output.createGraphics();  
        g2.setComposite(AlphaComposite.Src);  
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);  
        g2.setColor(Color.WHITE);  
        g2.fill(new RoundRectangle2D.Float(0, 0, w, h, cornerRadius, cornerRadius));  
        g2.setComposite(AlphaComposite.SrcAtop);  
        g2.drawImage(image, 0, 0, null);  
        g2.dispose();  
        return output;  
    }  

}
