package com.baijia.tianxiao.dto.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dto.FieldShow;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.google.common.base.Preconditions;
/**
 * 查询条件
 * @title QueryCondition
 * @desc TODO 
 * @author shizuwei
 * @date 2016年3月17日
 * @version 1.0
 */
@Data
@Slf4j
public class QueryCondition {
    private String fieldName;
    private Serializable lValue, rValue;

    public QueryCondition(String fieldName, Serializable lValue, Serializable rValue) {
        this.fieldName = fieldName;
        this.lValue = lValue;
        this.rValue = rValue;
    }

    public Expression toExpression(Map<String, FieldShow> mapper) {

        Preconditions.checkArgument(mapper != null, "mapper = null");
        FieldShow fshow = mapper.get(fieldName);
        Preconditions
            .checkArgument(fshow != null && StringUtils.isNoneBlank(fshow.getPoName()), "can't map to po name");
        Expression exp = null;
        String poName = fshow.getPoName();
        switch (fshow.getType()) {// 0,string；1，number;2，date
            case "STRING":
                exp = Expressions.like(poName, lValue);
            case "NUMBER":
            case "DATE":
                if (this.lValue != null) {
                    exp = Expressions.ge(poName, lValue);
                }
                if (this.rValue != null) {
                    if (exp == null) {
                        exp = Expressions.and(exp, Expressions.le(poName, rValue));
                    } else {
                        exp = Expressions.le(poName, rValue);
                    }

                }
        }

        return exp;
    }

    public static Expression andCondtions(Collection<QueryCondition> conditions, Map<String, FieldShow> mapper) {
        if (CollectionUtils.isEmpty(conditions)) {
            return null;
        }
        Expression exp = null;
        for (QueryCondition con : conditions) {
            Expression e = con.toExpression(mapper);
            if (e != null) {
                if (exp == null) {
                    exp = e;
                } else {
                    exp = Expressions.and(exp, e);
                }
            }
        }
        log.debug("con={},map={},exp = {}", conditions, mapper, exp);
        return exp;
    }

}
