
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

import com.google.common.collect.Lists;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import com.google.common.base.Preconditions;

/**
 * @title CsvUtils
 * @desc TODO
 * @author cxm
 * @date 2016年3月16日
 * @version 1.0
 */
public class CsvUtils {

    public static List<String[]> readCsvContent(File csvFile) throws IOException {
        Preconditions.checkArgument(csvFile != null && csvFile.exists(), "csv file error");
        List<String[]> result = Lists.newArrayList();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(csvFile);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (StringUtils.isNoneBlank(line)) {
                    result.add(line.split(","));
                }
            }
            return result;
        } catch (IOException e) {
            throw e;
        } finally {
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(fr);
        }

    }

}
