/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.http;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class WebCommonsUtils {
    public static String getIpAddr(HttpServletRequest request) {
        int index;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("http_client_ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null && (index = ip.indexOf(",")) != -1) {
            ip = ip.substring(0, index).trim();
        }
        return ip;
    }

    public static String getAllIpAddr(HttpServletRequest request) {
        StringBuilder allIp = new StringBuilder();
        String name = "x-forwarded-for";
        String ip = request.getHeader(name);
        if (StringUtils.isNotBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "Proxy-Client-IP"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "WL-Proxy-Client-IP"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "getRemoteAddr";
        ip = request.getRemoteAddr();
        if (StringUtils.isNotBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "http_client_ip"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "HTTP_X_FORWARDED_FOR"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        return allIp.toString();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            if (key.toLowerCase().indexOf("password") > -1) {
                params.put(key, "************");
                continue;
            }
            params.put(key, StringUtils.join((Object[])request.getParameterValues(key), (String)","));
        }
        return params;
    }
}

