/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static XSSFCell fillTheXSSFCellWithValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Object value, ParamType paramType) {
        XSSFRow row = sheet.getRow(rowNo);
        if (row == null) {
            row = sheet.createRow(rowNo);
        }
        XSSFCell cell = row.createCell(cellNo);
        if (cellStyle != null) {
            cell.setCellStyle(cellStyle);
        }
        if (value != null) {
            if (paramType == ParamType.type_int) {
                cell.setCellValue((double)((Integer)value).intValue());
            } else if (paramType == ParamType.type_double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (paramType == ParamType.type_string) {
                cell.setCellValue((String)value);
            } else if (paramType == ParamType.type_date) {
                cell.setCellValue((Date)value);
            } else {
                cell.setCellValue("");
            }
        } else {
            cell.setCellValue("");
        }
        return cell;
    }

    public static XSSFCell fillTheXSSFCellWithIntValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Integer value) {
        return ExcelUtils.fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_int);
    }

    public static XSSFCell fillTheXSSFCellWithDoubleValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Double value) {
        return ExcelUtils.fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_double);
    }

    public static XSSFCell fillTheXSSFCellWithStringValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, String value) {
        return ExcelUtils.fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_string);
    }

    public static XSSFCell fillTheXSSFCellWithDateValue(XSSFSheet sheet, int rowNo, int cellNo, CellStyle cellStyle, Date value) {
        return ExcelUtils.fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_date);
    }

    public static void fillCellStyleWithFullBorder(XSSFCellStyle cellStyle, short borderStyle, short borderColorIndex) {
        cellStyle.setBorderTop(borderStyle);
        cellStyle.setTopBorderColor(borderColorIndex);
        cellStyle.setBorderRight(borderStyle);
        cellStyle.setRightBorderColor(borderColorIndex);
        cellStyle.setBorderBottom(borderStyle);
        cellStyle.setBottomBorderColor(borderColorIndex);
        cellStyle.setBorderLeft(borderStyle);
        cellStyle.setLeftBorderColor(borderColorIndex);
    }

    public static void fillCellStyleWithBGColor(XSSFCellStyle cellStyle, XSSFColor fillForegroundColor, short fillPattern) {
        cellStyle.setFillForegroundColor(fillForegroundColor);
        cellStyle.setFillPattern(fillPattern);
    }

    public static Map<Integer, CellInfo> getCellInfoMap(XSSFSheet sheet, int demoRowNo, int demoCellStartNo, int demoCellEndNo) {
        HashMap<Integer, CellInfo> map = new HashMap<Integer, CellInfo>();
        while (demoCellStartNo <= demoCellEndNo) {
            System.out.println(sheet.getLastRowNum());
            System.out.println(sheet.getRow(demoRowNo));
            XSSFCell cell = sheet.getRow(demoRowNo).getCell(demoCellStartNo);
            if (cell != null) {
                CellInfo cellInfo = new CellInfo();
                cellInfo.setDataFormat(cell.getCellStyle().getDataFormat());
                cellInfo.setAlignment(cell.getCellStyle().getAlignment());
                map.put(demoCellStartNo, cellInfo);
            }
            ++demoCellStartNo;
        }
        return map;
    }

    public static XSSFCellStyle decorateStyleWithDataFormatMap(int cellNo, XSSFCellStyle cellStyle, Map<Integer, CellInfo> dataFormatMap) {
        CellInfo cellInfo;
        XSSFCellStyle style = (XSSFCellStyle)cellStyle.clone();
        if (dataFormatMap.get(cellNo) != null && (cellInfo = dataFormatMap.get(cellNo)) != null) {
            if (cellInfo.getDataFormat() != null) {
                style.setDataFormat(cellInfo.getDataFormat().shortValue());
            }
            if (cellInfo.getAlignment() != null) {
                style.setAlignment(cellInfo.getAlignment().shortValue());
            }
        }
        return style;
    }

    public static boolean isCellEmpty(XSSFRow row, int cellNo) {
        XSSFCell cell = row.getCell(cellNo);
        return cell == null || cell.getRawValue() == null || cell.getRawValue().equals("");
    }

    public static boolean isRowContainsEmpty(XSSFRow row, int startCellNo, int endCellNo) {
        for (int i = startCellNo; i <= endCellNo; ++i) {
            XSSFCell cell = row.getCell(i);
            if (cell != null && cell.getRawValue() != null && !cell.getRawValue().equals("")) continue;
            return true;
        }
        return false;
    }

    public static void cellTypeToString(XSSFRow row, int startCellNo, int endCellNo) {
        for (int i = startCellNo; i <= endCellNo; ++i) {
            row.getCell(i).setCellType(1);
        }
    }

    public static XSSFCellStyle getYellowBGStyle(XSSFWorkbook workbook) {
        XSSFCellStyle yellowStyle = workbook.createCellStyle();
        yellowStyle.setWrapText(true);
        yellowStyle.setLocked(false);
        yellowStyle.setFillPattern((short)1);
        yellowStyle.setFillForegroundColor(new XSSFColor(Color.YELLOW));
        return yellowStyle;
    }

    public static XSSFCellStyle getWhitewBGStyle(XSSFWorkbook workbook) {
        XSSFCellStyle whiteStyle = workbook.createCellStyle();
        whiteStyle.setWrapText(true);
        whiteStyle.setLocked(false);
        whiteStyle.setFillPattern((short)1);
        whiteStyle.setFillForegroundColor(new XSSFColor(Color.WHITE));
        return whiteStyle;
    }

    public static class CellInfo {
        Short dataFormat;
        Short alignment;

        public CellInfo() {
        }

        public CellInfo(Short dataFormat, Short alignment) {
            this.dataFormat = dataFormat;
            this.alignment = alignment;
        }

        public Short getDataFormat() {
            return this.dataFormat;
        }

        public void setDataFormat(Short dataFormat) {
            this.dataFormat = dataFormat;
        }

        public Short getAlignment() {
            return this.alignment;
        }

        public void setAlignment(Short alignment) {
            this.alignment = alignment;
        }
    }

    public static enum ParamType {
        type_int,
        type_double,
        type_string,
        type_date;

    }
}

