/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.filter;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class WrapLoginFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WrapLoginFilter.class);
    private static final String DEFAULT_COOKIE_NAME = "ORG_AUTH_TOKEN";
    private static final String TOKEN_FROM_COOKIERS_URL = "tokenFromCookiesUrl";
    private FilterConfig filterConfig;
    private List<String> tokenFromCookiesUrl = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        boolean hasInit = false;
        AppAuthToken token = null;
        if (session.getAttribute("LOGIN_SESSION") != null) {
            hasInit = true;
            token = (AppAuthToken)session.getAttribute("LOGIN_SESSION");
        }
        String path = request.getRequestURI().substring(request.getContextPath().length());
        log.info(" Request Path : {} ", (Object)path);
        if (!hasInit && this.tokenFromCookiesUrl.contains(path)) {
            token = this.initTokenFromCookie(request);
        }
        this.initPCContext(token);
        try {
            filterChain.doFilter((ServletRequest)request, servletResponse);
        }
        finally {
            TianxiaoPCContext.clear();
        }
    }

    private void initPCContext(AppAuthToken token) {
        if (token == null) {
            return;
        }
        TianxiaoPCContext.setAppAuthToken(token);
        log.debug("tx token\uff1a{}", (Object)token);
        TianxiaoPCContext.setOrgId(token.getUser_id().intValue());
        TianxiaoPCContext.setTXCascadeId(token.getTx_cascade_user_id());
        TianxiaoPCContext.setTXLoginAccountId(token.getTx_account_id());
    }

    private AppAuthToken initTokenFromCookie(HttpServletRequest request) throws JsonParseException, JsonMappingException, IOException {
        String encryptedToken = this.retrieveCookieValue(request);
        if (StringUtils.isNotBlank((CharSequence)encryptedToken)) {
            return JacksonUtil.str2Obj(EncryptUtils.strDecode(encryptedToken), AppAuthToken.class);
        }
        return null;
    }

    private String retrieveCookieValue(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)DEFAULT_COOKIE_NAME);
        if (log.isDebugEnabled()) {
            log.info("get token from cookie | cookieName:{}, cookie value:{}", (Object)DEFAULT_COOKIE_NAME, (Object)(cookie == null ? null : cookie.getValue()));
        }
        return cookie == null ? null : cookie.getValue();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        String initParameter = this.filterConfig.getInitParameter(TOKEN_FROM_COOKIERS_URL);
        if (GenericsUtils.notNullAndEmpty(initParameter)) {
            String[] urls = initParameter.split("[, ]+");
            this.tokenFromCookiesUrl.addAll(Arrays.asList(urls));
        }
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        String token = "DYAnenhqd2RuaSc_OT07ODIoaXooQHR7cnIyKXpoc3spQSlPbltoN3hQPio0Kmtpe2tpbG1ofnxue2hybStDd351djYsfoJpbWt9bWtub2qAfnB9anRvLUU8Qz44Lm2BgHQuRnqBeHg4L4GFbG5wcHyCe4FsdnIwSHyDenqL";
        AppAuthToken str2Obj = JacksonUtil.str2Obj(EncryptUtils.strDecode(token), AppAuthToken.class);
        System.out.println(str2Obj);
    }

    public void destroy() {
    }
}

