/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.util.storage;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dto.upload.UploadResult.UploadFile;
import com.baijia.tianxiao.util.file.FileUtil;
import com.baijia.tianxiao.util.properties.UploadProperties;

public class StorageUtil {

    /**
     * 构造主站图片url(参数对应cdb.storage表字段)
     * 
     * @param fid
     * @param mimeType
     * @param sn
     * @return
     */
    public static String constructUrl(Long fid, String mimeType, String sn) {
        String img_server = UploadProperties.getProperty("img.server");
        StringBuilder sb = new StringBuilder(img_server);
        String surfix = "";
        if (StringUtils.isNotBlank(mimeType)) {
            if (mimeType.contains("/")) {
                surfix = mimeType.split("/")[1];
            } else {
                surfix = mimeType;
            }
        }
        return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    }

    /**
     * 构造机构系统图片url(参数对应yunying.org_storage表字段)
     * 
     * @param fid
     * @param sn
     * @param mineType
     * @return
     */
    public static String constructUrl(String fid, String sn, Integer mineType) {
        MIMEType mimeType = MIMEType.getMimeType(mineType);
        return constructUrl(fid, sn, mimeType);
    }

    public static String constructUrl(String fid, String sn, MIMEType mineType) {
        String fileServer = null;

        if (mineType == null || mineType.equals(MIMEType.MP3) || mineType.equals(MIMEType.AMR)) {
            fileServer = UploadProperties.getProperty("file.server");
        } else {
            fileServer = UploadProperties.getProperty("img.server");
        }

        StringBuilder sb = new StringBuilder(fileServer);
        String surfix = mineType.getExtension();
        return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    }

    public static String constructUrl(UploadFile uploadFile) {
        String fileServer = null;
        String fileName = uploadFile.getUrl();
        if (MIMEType.imgExtension.contains(FileUtil.getFormatedExtension(fileName))) {
            fileServer = UploadProperties.getProperty("img.server");
        } else {
            fileServer = UploadProperties.getProperty("file.server");
        }
        return fileServer + uploadFile.getUrl();
    }

}
