/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.util.date;

import com.google.common.base.Preconditions;

import lombok.Data;

/**
 * @title TimeStamp
 * @desc TODO
 * @author cxm
 * @date 2015年10月15日
 * @version 1.0
 */
@Data
public class TimeStamp {

    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";

    public static final TimeStamp ZERO_TIME = parse("00:00:00");

    public static final TimeStamp DAY_LAST_TIME = parse("23:59:59");

    private int hour;

    private int minute;

    private int second;

    private int millisecond;

    public TimeStamp(int hour, int minute, int second) {
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    public TimeStamp(int hour, int minute) {
        this.hour = hour;
        this.minute = minute;
    }

    public static TimeStamp parse(String time, String pattern) {
        Preconditions.checkNotNull(time, "time string is null");
        Preconditions.checkNotNull(pattern, "pattern can not be null");

        String[] times = time.split(":");

        if (!pattern.equals(DEFAULT_TIME_PATTERN)) {
            // TODO 解析模板
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (times.length > 0) {
            hour = Integer.parseInt(times[0]);
        }

        if (times.length > 1) {
            minute = Integer.parseInt(times[1]);
        }

        if (times.length > 2) {
            second = Integer.parseInt(times[2]);
        }
        return new TimeStamp(hour, minute, second);
    }

    public static TimeStamp parse(String time) {
        return parse(time, DEFAULT_TIME_PATTERN);
    }
    
}
