package com.baijia.tianxiao.util.date;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class JodaDateUtil {

	public static int getDayOfMonth(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		return d.getDayOfMonth();
	}

	public static String getSimpleMonthBegin(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), 1, 0, 0, 0, 0);
		String s = d.toString("yyyy-MM");
		return s;
	}

	public static String getMonthBegin(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), 1, 0, 0, 0, 0);
		String s = d.toString("yyyy-MM-dd HH:mm:ss");
		System.out.println(s);
		return s;
	}

	public static long getMonthBeginTimeStamp(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), 1, 0, 0, 0, 0);
		return d.getMillis();
	}

	public static long getNextMonthBeginTs(long timestamp) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), 1, 0, 0, 0, 0);
		d = d.plusMonths(1);
		return d.getMillis();
	}

	public static long getHourDayTs(Long timestamp, int hour, int minute) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), hour, minute, 0, 0);
		return d.getMillis();
	}

	public static long getDayOfMonthTs(String monthOfFull, int dayOfMonth) {
		int year = Integer.valueOf(StringUtils.substringBefore(monthOfFull, "-"));
		int month = Integer.valueOf(StringUtils.substringAfter(monthOfFull, "-"));
		DateTime d = new DateTime(year, month, dayOfMonth, 0, 0, 0, 0);
		return d.getMillis();
	}

	/**
	 * 获取某个月的时间戳
	 * 
	 * @param monthOfFull
	 * @param previewMonth
	 * @param dayOfMonth
	 * @return
	 */
	public static String getDayOfPreviewMonth(String monthOfFull, int previewMonth, int dayOfMonth) {
		int year = Integer.valueOf(StringUtils.substringBefore(monthOfFull, "-"));
		int month = Integer.valueOf(StringUtils.substringAfter(monthOfFull, "-"));
		DateTime d = new DateTime(year, month, dayOfMonth, 0, 0, 0, 0);
		d = d.minusMonths(previewMonth);
		String s = d.toString("yyyy-MM-dd HH:mm:ss");
		return s;
	}

	public static long getDayOfPreviewMonthTs(String monthOfFull, int previewMonth, int dayOfMonth) {
		int year = Integer.valueOf(StringUtils.substringBefore(monthOfFull, "-"));
		int month = Integer.valueOf(StringUtils.substringAfter(monthOfFull, "-"));
		DateTime d = new DateTime(year, month, dayOfMonth, 0, 0, 0, 0);
		d = d.minusMonths(previewMonth);
		return d.getMillis();
	}

	public static String getDayOfNextMonth(String monthOfFull, int nextMonth, int dayOfMonth) {
		int year = Integer.valueOf(StringUtils.substringBefore(monthOfFull, "-"));
		int month = Integer.valueOf(StringUtils.substringAfter(monthOfFull, "-"));
		DateTime d = new DateTime(year, month, dayOfMonth, 0, 0, 0, 0);
		d = d.plusMonths(nextMonth);
		String s = d.toString("yyyy-MM-dd HH:mm:ss");
		return s;
	}

	public static long getDayOfNextMonthTs(String monthOfFull, int nextMonth, int dayOfMonth) {
		int year = Integer.valueOf(StringUtils.substringBefore(monthOfFull, "-"));
		int month = Integer.valueOf(StringUtils.substringAfter(monthOfFull, "-"));
		DateTime d = new DateTime(year, month, dayOfMonth, 0, 0, 0, 0);
		d = d.plusMonths(nextMonth);
		return d.getMillis();
	}

	public static long getCalMonthBeginTs(String monthOfFull) {
		int year = Integer.valueOf(StringUtils.substringBefore(monthOfFull, "-"));
		int month = Integer.valueOf(StringUtils.substringAfter(monthOfFull, "-"));
		DateTime d = new DateTime(year, month, 1, 0, 0, 0, 0);
		return d.getMillis();
	}

	/**
	 * 获取当前天提前n天的timestamp
	 * 
	 * @param timestamp
	 * @param minus
	 * @return
	 */
	public static long getDayBeginTimeStamp(Long timestamp, int minus) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), 0, 0, 0, 0);
		d = d.minusDays(minus);
		return d.getMillis();
	}
	
	public static String getDayBegin(Long timestamp, int minus) {
        DateTime d = new DateTime(timestamp);
        d = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), 0, 0, 0, 0);
        d = d.minusDays(minus);
        return d.toString("yyyy-MM-dd");
    }

	public static long getDayNextTimeStamp(Long timestamp, int plus) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), 0, 0, 0, 0);
		d = d.plusDays(plus);
		return d.getMillis();
	}

	public static String getNextMonthBegin(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), 1, 0, 0, 0, 0);
		DateTime nextDate = d.plusMonths(1);
		String s = nextDate.toString("yyyy-MM-dd HH:mm:ss");
		System.out.println(s);
		return s;
	}

	public static long getNextMonthBeginTs(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		d = new DateTime(d.getYear(), d.getMonthOfYear(), 1, 0, 0, 0, 0);
		DateTime nextDate = d.plusMonths(1);
		return nextDate.getMillis();
	}

	// 获取当月有多少天
	public static int getDay(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		return d.getDayOfMonth();
	}

	public static long getMonthPlusTs(Long timestamp, int monthPlus) {
		DateTime d = new DateTime(timestamp);
		DateTime nextDate = d.plusMonths(monthPlus);
		return nextDate.getMillis();
	}

	public static String generateSalaryMonth(Long timestamp) {
		DateTime d = new DateTime(timestamp);
		DateTime prewDate = d.minusMonths(1);
		return "" + prewDate.getYear() + "-" + prewDate.getMonthOfYear();

	}


}
