/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.HashMap;
import java.util.Map;


/**   
 * @Title       : WebResponseHelper 
 * @Description : 
 * @Author      : zhenyujian
 * @Date        : 2015年12月1日 上午11:50:25 
 * @Version     : v1.0   
 */
public class WebResponseHelper {

	public static <T> WebResponse<T> success(){
		return new WebResponse<T>();
	}
	
	public static <T> WebResponse<T> success(T data){
		return new WebResponse<T>(data);
	}
	
    public static <T> WebResponse<T> success(T data, String msg) {
        WebResponse<T> resp = new WebResponse<T>(data);
        resp.setMsg(msg);
        return resp;
    }

	public static <T> WebResponse<T> success(T data, PageDto pageDto){
		return new WebResponse<T>(data,pageDto);
	}

	public static <T> WebResponse<T> error(){
		return new WebResponse<T>(CommonErrorCode.UNKNOW);
	}
	public static <T> WebResponse<T> error(UniverseErrorCode errorCode){
		return new WebResponse<T>(errorCode);
	}
	
	
	public static <T> WebResponse<T> error(UniverseErrorCode errorCode, String msg){
		return new WebResponse<T>(errorCode,msg);
	}
	
    public static <T> WebResponse<T> error(UniverseErrorCode errorCode, T data, String msg) {
        WebResponse<T> resp = new WebResponse<T>(errorCode, msg);
        resp.setData(data);
        return resp;
    }

	public static WebResponse<?> successData(){
		Map<String,Object> map = new HashMap<String,Object>();
		return new WebResponse<>(map);
	}
}

