/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.google.common.base.Preconditions;

import lombok.extern.slf4j.Slf4j;

/**
 * @title ShortUrlUtil
 * @desc TODO
 * @author cxm
 * @date 2015年10月26日
 * @version 1.0
 */
@Slf4j
public class ShortUrlUtil {

    @SuppressWarnings("unchecked")
    public static String getShortUrl(String longUrl) {
        Preconditions.checkArgument(StringUtils.isNoneBlank(longUrl), "long url is empty");
        try {
            String url = UrlProperties.getProperty("shorturl.api");
            Map<String, String> params = new HashMap<String, String>();
            params.put("long_url", longUrl);
            
            //给伊利预留个来源区分，他后面直接返回tx100.cc的短链
            params.put("origin", "tianxiao");
            
            log.info("transfer long url:{} into short url.", longUrl);
            String response = HttpClientUtils.doGet(url, params);
            Map<String, Object> responseMap;
            responseMap = JacksonUtil.str2Obj(response, Map.class);
            if (responseMap.containsKey("data")) {
                Map<String, String> dataMap = (Map<String, String>) responseMap.get("data");
                return txShortUrl(dataMap.get("short_url"));
            }
        } catch (Exception e) {
            log.error("get short url catch error:{} and will return origin url ", e);
        }
        // 如果转换长连接出现异常时，直接返回原链接（长连接）
        return longUrl;
    }
    
    
    /**
     * 获得天校的短链接
     * http://gensx.com/Adf84 -> http://tx100.cc/Adf84
     * @author taoyaping
     * @param orginGensxShortUrl
     * @return
     */
    private static String txShortUrl(String orginGensxShortUrl) {

        if(StringUtils.isNoneBlank(orginGensxShortUrl)) {
            return orginGensxShortUrl.replaceFirst("gensx\\.cn", "tx100.cc");
        }
        
        return orginGensxShortUrl;
    }

    
}
