package com.baijia.tianxiao.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ListUtil {

    private static Logger logger = LoggerFactory.getLogger(ListUtil.class);

    public static <T> List<T> getSubList(List<T> list, int offset, int count) {
        if (offset < 0) {
            offset = 0;
        }
        if (list == null || list.size() - 1 < offset) {
            return new ArrayList<T>();
        }
        int end = (list.size() > offset + count) ? offset + count : list.size();
        return list.subList(offset, end);
    }

    public static <K, V> void insertIntoMap(Map<K, V> map, List<K> keys, V value) {
        if (map != null && keys != null) {
            for (K key : keys) {
                map.put(key, value);
            }
        }
    }

    public static boolean allNull(Object first, Object...objects) {
        if (first != null) {
            return false;
        } else if (ArrayUtils.isEmpty(objects)) {
            return true;
        }
        for (Object o : objects) {
            if (o != null) {
                return false;
            }
        }
        return true;
    }

    public static boolean allNotNull(Object first, Object...objects) {
        if (first == null) {
            return false;
        } else if (ArrayUtils.isEmpty(objects)) {
            return true;
        }
        for (Object o : objects) {
            if (o == null) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasNull(Object first, Object...objects) {
        if (first == null) {
            return true;
        } else if (ArrayUtils.isEmpty(objects)) {
            return false;
        }
        for (Object o : objects) {
            if (o == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasNotNull(Object first, Object...objects) {
        if (first != null) {
            return true;
        } else if (ArrayUtils.isEmpty(objects)) {
            return false;
        }
        for (Object o : objects) {
            if (o != null) {
                return true;
            }
        }
        return false;
    }

    public static <T> boolean in(T value, T...list) {
        if (ArrayUtils.isEmpty(list)) {
            return false;
        }
        for (T t : list) {
            if (ObjectUtils.equals(value, t)) {
                return true;
            }
        }
        return false;
    }

    public static <T> boolean notIn(T value, T...list) {
        return !in(value, list);
    }

    public static boolean or(boolean...values) {
        return BooleanUtils.or(values);
    }

    public static boolean and(boolean...values) {
        return BooleanUtils.and(values);
    }

    @SuppressWarnings("unchecked")
    public static <K, V> List<K> toKeyList(Collection<? extends V> list, String field, Class<V> clazz) {
        List<K> retList = new ArrayList<K>();
        if (list != null && list.size() > 0) {
            for (V value : list) {
                retList.add((K) getKey(value, field, clazz));
            }
        }
        return retList;
    }

    @SuppressWarnings("unchecked")
    private static <K, V> K getKey(V value, String field, Class<V> clazz) {
        String method = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
        K key = null;
        try {
            key = (K) clazz.getMethod(method).invoke(value);
        } catch (Exception e) {
            logger.warn("[Exception]", e);
        }
        return key;
    }
}
