/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.interceptor;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.baijia.tianxiao.dto.AppBaseResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.util.json.JacksonUtil;

/**
 * @title ErrorInterceptor
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年6月17日
 * @version 1.0
 */
    
public class ErrorInterceptor extends HandlerInterceptorAdapter {

    private static final Logger logger = LoggerFactory.getLogger(ErrorInterceptor.class);

    @Override
    public void afterCompletion(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler,
        Exception ex) throws Exception {
        if (null != ex) {
            handUnDeclaredException(ex, httpResponse);
        }
    }

    protected void handUnDeclaredException(Throwable ex, HttpServletResponse httpResponse) {
        AppBaseResponse response = new AppBaseResponse("网络异常", CommonErrorCode.SYSTEM_ERROR.getSubsystemErrorCode(), null);
        logger.error("Handled unDeclared error ", ex);

        try {
            httpResponse.setContentType("application/json;charset=UTF-8");
            JacksonUtil.writeObj(httpResponse.getOutputStream(), response);
        } catch (IOException e) {
            logger.error("ioexception:{}", e);
        }

    }

}