/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.exception;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;


/**   
 * @Title       : CustomException 
 * @Description : 自定义异常类
 * @Author      : zhenyujian
 * @Date        : 2015年12月1日 下午2:44:47 
 */
public class CustomException extends RuntimeException{

	private static final long serialVersionUID = -5653207638917828094L;
	private static final UniverseErrorCode DEFAULT_ERRORCODE = CommonErrorCode.UNKNOW;
	
	protected String message;
    protected UniverseErrorCode errorCode;

    public CustomException() {
    }

	public final UniverseErrorCode getErrorCode() {
		if(this.errorCode == null){
			return DEFAULT_ERRORCODE;
		}
		return errorCode;
	}
	
	@Override
    public final String getMessage() {
    	if(this.message == null){
    		return this.getErrorCode().getMessage();
    	}
        return this.message;
    }
}

