package com.baijia.tianxiao.enums;

public enum SMSType {

    SMS_VERIFY_CODE (1, "验证码消息"),
    
    SMS_NOTICE (2, "通知消息"),
    
    SMS_MARKETING (3, "营销消息"),
    
    SMS_IM (4, "IM消息"),
    
    SMS_VOICE_CODE(10, "语音验证码"),
    
    SMS_INTERNAL_MSG(20, "国际短信");
    
    private int value;
    
    private String label;
    
    private SMSType (int value, String label) {
        this.value = value;
        this.label = label;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }
    
    public static SMSType get(Integer value){
        for(SMSType type : SMSType.values()){
            if(type.getValue() == value){
                return type;
            }
        }
        return null;
    }
}
