/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dto.smstoken;


import java.util.Map;

import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.CourseSmsTokenUtil.SmsToken;

import lombok.Data;

/**   
 * @title       : WechatSmsTokenDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年9月1日 下午7:58:36 
 */
@Data
public class TeacherSmsTokenDto extends SmsTokenDto{
	 private Long orgId;
	 private String wechatAppId;
	 private Long teacherId;
	 private String openId;
	
	 private TeacherSmsTokenDto (){
	 }
	
	 public TeacherSmsTokenDto(Long orgId, String wechatAppId, Long teacherId, String openId){
		 this.orgId = orgId;
		 this.wechatAppId = wechatAppId;
		 this.teacherId = teacherId;
		 this.openId = openId;
	 }

	public static TeacherSmsTokenDto fromTokenStr(String tokenStr) throws Exception {
		TeacherSmsTokenDto obj = new TeacherSmsTokenDto();
		SmsToken token = CourseSmsTokenUtil.decodeToken(tokenStr);
		Map<String, Object> map = token.getParams();
		
		obj.setOrgId( map.get("orgId")!=null ? Long.parseLong(map.get("orgId").toString()) : null );
		obj.setWechatAppId( map.get("wechatAppId")!=null ? map.get("wechatAppId").toString() : null );
		obj.setTeacherId( map.get("teacherId")!=null ? Long.parseLong(map.get("teacherId").toString()) : null );
		obj.setOpenId( map.get("openId")!=null ? map.get("openId").toString() : null );
		
		return obj;
	}
	
	public static void main(String args[]) throws Exception{
		String token = "CHsidHMiOjE0ODQ5NzIzOjM0OTMuJHF0aUxnJT03NDQ7PTAmdGV2ZXF4Jz-AJ3R3bE9qKEA6Nzc-QDMpfmxqb2h8SXh4UWwqQiuAgUBta0JrcDtCa29BQ29tbUMtiDctgXF-f3V7ei5GPoo";
		System.out.println(CourseSmsTokenUtil.decodeToken(token));
	}
}

