package com.baijia.tianxiao.constants;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * @version 1.0
 * @title TianXiaoConstant
 * @desc 定义天校系统公用的一些常量
 */
public class TianXiaoConstant {

    public static final char[] LETTER_POOL = { 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'a', 's', 'd', 'f', 'h', 'j', 'k',
        'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'p' };
    public static final char[] NUM_POOL = { '9', '6', '3', '2', '5', '8', '7', '4', '1' };
    public static final int RANDOM_PASS_LENGTH = 6;

    // APP请求成功状态码
    public static final int SUCC_CODE = 0;

    // APP请求失败状态码
    public static final int ERRO_CODE = 1;

    // 机构主页pv存储reids db number
    public static final int TX_PV_REDIS_DB = 6;

    // 天校页面存储REDIS的key格式 TX#MONITOR#PV#${YYYYmmDD}#${ORG_NUMBER}#${PAGE_KET}#${USER_ID}#${COURSE_NUMBER}
    public static final String TX_PV_REDIS_PRE = "TX#MONITOR#PV#";

    public static final String TX_MSG_REDIS_PRE = "TX#MESSAGE#PV#";

    public static final int DEFAULT_PAGE_SIZE = 10;

    public static final int WITHDRAW_TIME=1;//天校提现次数

    // 最大上传字节数
    public static final long MAX_UPLOAD_SIZE_IN_BYTE = 5242880L;

    public static final SimpleDateFormat DAY_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static final SimpleDateFormat MONTH_FORMAT = new SimpleDateFormat("yyyy年MM月");

    public static final SimpleDateFormat TIME_MINUTE_FORMAT = new SimpleDateFormat("HH:mm");

    public static final String APPOINTMENT_STUDENT_NAME = "在线留单学生";

    public static final String ANONYMOUS_CONSULT_USER = "访客";

    public static final Calendar MAX_TIMESTAMP_CALEN = new GregorianCalendar(2037, 1, 1);

    public static final String DEFAULT_CLASS_COVER="http://img.gsxservice.com/10497162_byhm2qrj.png";

}
