
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.constants;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title 处理的数据类型定义
 * @desc TODO
 * @author shanyu
 * @date 2016年3月14日
 * @version 1.0
 */

public enum DataProcType {

    COURSE(1, "课程列表"),

    CONSULT(2, "线索"),

    ORG_STUDENT(3, "学员档案"),
    
    COURSE_STUDENT(4, "课程学员"),

    COURSE_1V1(5,"1v1课程列表"),

    CLASS_1V1(6,"1v1班级列表")
    ;

    private static final Map<Integer, DataProcType> map = Maps.newHashMap();

    private int type;

    private String note;

    static {
        for (DataProcType dataProcType : DataProcType.values()) {
            map.put(dataProcType.type, dataProcType);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getNote() {
        return this.note;
    }

    private DataProcType(Integer type, String note) {
        this.type = type;
        this.note = note;
    }

    public static DataProcType getByType(Integer type) {
        return map.get(type);
    }
}
