/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.memcached;

import com.baijia.tianxiao.util.ServiceLocator;
import com.google.code.yanf4j.core.impl.StandardSocketOption;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedUtil {
    private static final int DEF_EXP = 3600;
    private static TxMemcachedClient memcachedClient;
    private static final Logger logger;
    private static Lock lock;

    public static boolean delete(String arg0) throws TimeoutException, InterruptedException, MemcachedException {
        if (StringUtils.isBlank((CharSequence)arg0)) {
            return false;
        }
        return MemcachedUtil.getClient().delete(arg0);
    }

    public static <T> T get(String arg0) throws TimeoutException, InterruptedException, MemcachedException {
        return MemcachedUtil.getClient().get(arg0);
    }

    public static boolean set(String arg0, int arg1, Object arg2) throws TimeoutException, InterruptedException, MemcachedException {
        return MemcachedUtil.getClient().set(arg0, arg1, arg2);
    }

    public static boolean set(String arg0, Object arg1) throws TimeoutException, InterruptedException, MemcachedException {
        return MemcachedUtil.getClient().set(arg0, 3600, arg1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TxMemcachedClient getClient() {
        if (memcachedClient == null) {
            lock.lock();
            if (memcachedClient == null) {
                XMemcachedClientBuilder builder1 = (XMemcachedClientBuilder)ServiceLocator.getBean("memcachedClientBuilder");
                builder1.getSocketOptions().put(StandardSocketOption.TCP_NODELAY, Boolean.TRUE);
                XMemcachedClientBuilder builder2 = (XMemcachedClientBuilder)ServiceLocator.getBean("memcachedClientBuilder2");
                builder2.getSocketOptions().put(StandardSocketOption.TCP_NODELAY, Boolean.TRUE);
                try {
                    MemcachedClient memcachedClient1 = builder1.build();
                    MemcachedClient memcachedClient2 = builder2.build();
                    memcachedClient = new TxMemcachedClient(memcachedClient2, memcachedClient1);
                }
                catch (IOException e) {
                    logger.error("memcache getClient error", (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return memcachedClient;
    }

    public void shutdown() {
        Object[] memcachedClients = memcachedClient.getMemcachedClients();
        if (ArrayUtils.isNotEmpty((Object[])memcachedClients)) {
            for (Object client : memcachedClients) {
                if (client == null || client.isShutdown()) continue;
                try {
                    client.shutdown();
                }
                catch (IOException e) {
                    logger.error("shutdown MemcachedClient error!client:" + client, (Throwable)e);
                }
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(MemcachedUtil.class);
        lock = new ReentrantLock();
    }

    static class TxMemcachedClient {
        private MemcachedClient[] memcachedClients;

        public TxMemcachedClient(MemcachedClient ... clients) {
            if (clients != null && clients.length > 0) {
                this.memcachedClients = new MemcachedClient[clients.length];
                int index = 0;
                for (MemcachedClient client : clients) {
                    this.memcachedClients[index++] = client;
                }
            }
        }

        public boolean delete(String arg0) throws TimeoutException, InterruptedException, MemcachedException {
            if (StringUtils.isBlank((CharSequence)arg0)) {
                return false;
            }
            for (MemcachedClient client : this.memcachedClients) {
                client.delete(arg0);
            }
            return true;
        }

        public <T> T get(String arg0) throws TimeoutException, InterruptedException, MemcachedException {
            int count = 0;
            for (MemcachedClient client : this.memcachedClients) {
                ++count;
                try {
                    Object t = client.get(arg0);
                    if (t == null) continue;
                    return (T)t;
                }
                catch (InterruptedException | TimeoutException | MemcachedException e) {
                    if (count < this.memcachedClients.length) continue;
                    throw e;
                }
            }
            return null;
        }

        public boolean set(String arg0, int arg1, Object arg2) throws TimeoutException, InterruptedException, MemcachedException {
            boolean isSuccess = false;
            for (MemcachedClient client : this.memcachedClients) {
                try {
                    if (!client.set(arg0, arg1, arg2)) continue;
                    isSuccess = true;
                }
                catch (InterruptedException | TimeoutException | MemcachedException e) {
                    if (isSuccess) continue;
                    throw e;
                }
            }
            return isSuccess;
        }

        public boolean set(String arg0, Object arg1) throws TimeoutException, InterruptedException, MemcachedException {
            boolean isSuccess = false;
            for (MemcachedClient client : this.memcachedClients) {
                try {
                    if (!client.set(arg0, 3600, arg1)) continue;
                    isSuccess = true;
                }
                catch (InterruptedException | TimeoutException | MemcachedException e) {
                    if (isSuccess) continue;
                    throw e;
                }
            }
            return isSuccess;
        }

        public MemcachedClient[] getMemcachedClients() {
            return this.memcachedClients;
        }
    }
}

