/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.storage;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.util.file.FileUtil;
import com.baijia.tianxiao.util.properties.UploadProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class StorageUtil {
    @Autowired
    public static String constructUrl(Long fid, String mimeType, String sn) {
        String img_server = UploadProperties.getProperty("img.server");
        StringBuilder sb = new StringBuilder(img_server);
        String surfix = "";
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            surfix = mimeType.contains("/") ? mimeType.split("/")[1] : mimeType;
        }
        return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    }

    public static String constructUrl(String fid, String sn, Integer mineType) {
        MIMEType mimeType = MIMEType.getMimeType(mineType);
        return StorageUtil.constructUrl(fid, sn, mimeType);
    }

    public static String constructUrl(String fid, String sn, MIMEType mineType) {
        String fileServer = null;
        fileServer = mineType == null || mineType.equals((Object)MIMEType.MP3) || mineType.equals((Object)MIMEType.AMR) ? UploadProperties.getProperty("file.server") : UploadProperties.getProperty("img.server");
        StringBuilder sb = new StringBuilder(fileServer);
        String surfix = mineType.getExtension();
        return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    }

    public static String constructFileUrl(String fid, String sn, String mimeType) {
        String fileServer = null;
        fileServer = UploadProperties.getProperty("file.server");
        StringBuilder sb = new StringBuilder(fileServer);
        String surfix = mimeType;
        return sb.append(fid).append("_").append(sn).append(".").append(surfix).toString();
    }

    public static String constructUrl(UploadResult.UploadFile uploadFile) {
        String fileServer = null;
        String fileName = uploadFile.getUrl();
        fileServer = MIMEType.imgExtension.contains(FileUtil.getFormatedExtension(fileName)) ? UploadProperties.getProperty("img.server") : UploadProperties.getProperty("file.server");
        return fileServer + uploadFile.getUrl();
    }
}

