/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.page;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PageUtils {
    public static <T> List<T> getList(List<T> list, PageDto page) {
        if (page == null) {
            return list;
        }
        page.setCount(Integer.valueOf(list.size()));
        ArrayList subList = Lists.newArrayList();
        int offset = page.firstNum();
        int count = 0;
        for (int i = offset; i < list.size(); ++i) {
            if (count >= page.getPageSize()) continue;
            subList.add(list.get(i));
            ++count;
        }
        page.setCurPageCount(Integer.valueOf(subList.size()));
        return subList;
    }

    public static <T> List<T> getListWithValidate(List<T> list, PageDto pageDto) {
        int startNum;
        if (pageDto == null) {
            return list;
        }
        if (CollectionUtils.isEmpty(list)) {
            pageDto.setCount(Integer.valueOf(0));
            pageDto.setCurPageCount(Integer.valueOf(0));
            return Collections.emptyList();
        }
        Integer count = list.size();
        Integer pageNum = (count - 1) / pageDto.getPageSize() + 1;
        if (pageDto.getPageNum() > pageNum) {
            return Collections.emptyList();
        }
        Integer lastPageCount = count % pageDto.getPageSize() == 0 ? pageDto.getPageSize() : count % pageDto.getPageSize();
        if (pageDto.getPageNum() < pageNum) {
            pageDto.setCurPageCount(pageDto.getPageSize());
        } else {
            pageDto.setCurPageCount(lastPageCount);
        }
        pageDto.setCount(count);
        ArrayList result = Lists.newArrayList();
        for (int i = startNum = (pageDto.getPageNum() - 1) * pageDto.getPageSize(); i < startNum + pageDto.getCurPageCount(); ++i) {
            result.add(list.get(i));
        }
        return result;
    }
}

