/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JacksonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static final String obj2Str(Object o) {
        try {
            return mapper.writeValueAsString(o);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void writeObj(OutputStream out, Object value) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(out, value);
    }

    public static final <T> T str2Obj(String s, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        JavaType javaType = JacksonUtil.getJavaType(valueType, null);
        return (T)mapper.readValue(s, javaType);
    }

    protected static JavaType getJavaType(Type type, Class<?> contextClass) {
        return contextClass != null ? mapper.getTypeFactory().constructType(type, contextClass) : mapper.constructType(type);
    }

    public static final <T> T str2Obj(String s, TypeReference<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(s, valueType);
    }

    public static final <T> List<T> str2List(String s, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{valueType});
        return (List)mapper.readValue(s, javaType);
    }

    public static final <T> T readObj(InputStream in, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(in, valueType);
    }

    public static final <T> T readObj(InputStream in, JavaType valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)mapper.readValue(in, valueType);
    }

    public static final Map<String, Object> obj2Map(Object o) {
        HashMap map = Maps.newHashMap();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(o, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    static {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

