/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.http;

import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;

public class WebCommonsUtils {
    public static void returnWebResponse(HttpServletResponse response, WebResponse<T> webResponse) {
        WebCommonsUtils.returnMessage(response, JacksonUtil.obj2Str(webResponse));
    }

    public static void returnMessage(HttpServletResponse response, String content) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        PrintWriter pWriter = null;
        try {
            pWriter = response.getWriter();
            pWriter.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (pWriter != null) {
                pWriter.flush();
                pWriter.close();
            }
        }
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("x-requested-with");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)requestedWith)) {
            return false;
        }
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)requestedWith) && requestedWith.equals("XMLHttpRequest");
    }

    public static String getIpAddr(HttpServletRequest request) {
        int index;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("http_client_ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip != null && (index = ip.indexOf(",")) != -1) {
            ip = ip.substring(0, index).trim();
        }
        return ip;
    }

    public static String getAllIpAddr(HttpServletRequest request) {
        StringBuilder allIp = new StringBuilder();
        String name = "x-forwarded-for";
        String ip = request.getHeader(name);
        if (StringUtils.isNotBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "Proxy-Client-IP"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "WL-Proxy-Client-IP"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        name = "getRemoteAddr";
        ip = request.getRemoteAddr();
        if (StringUtils.isNotBlank((String)ip) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "http_client_ip"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        if (StringUtils.isNotBlank((String)(ip = request.getHeader(name = "HTTP_X_FORWARDED_FOR"))) && !"unknown".equalsIgnoreCase(ip)) {
            allIp.append(name).append(":").append(ip).append(",");
        }
        return allIp.toString();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : request.getParameterMap().keySet()) {
            if (key.toLowerCase().indexOf("password") > -1) {
                params.put(key, "************");
                continue;
            }
            params.put(key, StringUtils.join((Object[])request.getParameterValues(key), (String)","));
        }
        return params;
    }
}

