/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.excel;

import com.baijia.tianxiao.annotation.AnchorContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ExportUtils<T> {
    public static <T> Map<String, List<String>> generateHeader(Class<T> clazz) {
        HashMap result = Maps.newHashMap();
        ArrayList headers = Lists.newArrayList();
        ArrayList fieldNames = Lists.newArrayList();
        List<Object> fields = Lists.newArrayList();
        for (Class<T> superClass = clazz; superClass != null; superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(Arrays.copyOf(superClass.getDeclaredFields(), superClass.getDeclaredFields().length)));
        }
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            fields = fields.stream().filter(f -> f.getAnnotation(AnchorContext.class) != null).sorted(new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getAnnotation(AnchorContext.class).position() - o2.getAnnotation(AnchorContext.class).position();
                }
            }).collect(Collectors.toList());
        }
        for (Field field : fields) {
            AnchorContext context = field.getAnnotation(AnchorContext.class);
            fieldNames.add(field.getName());
            headers.add(context.header());
        }
        result.put("headers", headers);
        result.put("fieldNames", fieldNames);
        return result;
    }
}

