/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.excel;

import com.baijia.tianxiao.util.excel.ExcelCell;
import com.baijia.tianxiao.util.excel.ExcelCellStyle;
import com.baijia.tianxiao.util.excel.Excelable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelHelper<T> {
    public void exportToExcel(HttpServletRequest request, HttpServletResponse response, List<T> data, List<String> fields, List<String> fieldValue) {
        this.exportToExcel(request, response, data, fields, fieldValue, null);
    }

    public void exportToExcel(HttpServletRequest request, HttpServletResponse response, List<T> data, List<String> fields, List<String> fieldValue, String fileName) {
        int i;
        if (fields == null || fieldValue == null) {
            throw new RuntimeException("fields or header can't be null.");
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet("ExportDataList");
        Row headerTitle = sheet.createRow(0);
        int index = 0;
        for (i = 0; i < fields.size(); ++i) {
            Cell cell = headerTitle.createCell(index++ % fields.size());
            cell.setCellValue(fieldValue.get(i));
        }
        for (i = 0; i < data.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            T o = data.get(i);
            for (int j = 0; j < fields.size(); ++j) {
                Cell cell = row.createCell(index++ % fields.size());
                try {
                    cell.setCellValue(BeanUtils.getProperty(o, (String)fields.get(j)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("export data error", e);
                }
            }
        }
        if (fileName == null || "".equals(fileName)) {
            fileName = System.currentTimeMillis() + ".xls";
        }
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "utf-8"));
        }
        catch (UnsupportedEncodingException e1) {
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        }
        try {
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    public void exportToExcel(HttpServletRequest request, HttpServletResponse response, String fileName, SheetWrapper ... sheetWrappers) {
        HSSFWorkbook wb = new HSSFWorkbook();
        if (null != sheetWrappers) {
            int sheetIndex = 1;
            for (SheetWrapper sheetWrapper : sheetWrappers) {
                int i;
                String[] fields = sheetWrapper.fields;
                String[] fieldValue = sheetWrapper.fieldValue;
                List data = sheetWrapper.data;
                if (fields == null || fieldValue == null) {
                    throw new RuntimeException("fields or header can't be null.");
                }
                Sheet sheet = wb.createSheet(StringUtils.isNotBlank((String)sheetWrapper.sheetName) ? sheetWrapper.sheetName : "ExportDataList" + sheetIndex++);
                Row headerTitle = sheet.createRow(0);
                int index = 0;
                for (i = 0; i < fields.length; ++i) {
                    Cell cell = headerTitle.createCell(index++ % fields.length);
                    cell.setCellValue(fieldValue[i]);
                }
                for (i = 0; i < data.size(); ++i) {
                    Row row = sheet.createRow(i + 1);
                    Object o = data.get(i);
                    for (int j = 0; j < fields.length; ++j) {
                        Cell cell = row.createCell(index++ % fields.length);
                        try {
                            cell.setCellValue(BeanUtils.getProperty(o, (String)fields[j]));
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("export data error", e);
                        }
                    }
                }
            }
        }
        if (fileName == null || "".equals(fileName)) {
            fileName = System.currentTimeMillis() + ".xls";
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        try {
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    public <A> void exportToExcel(HttpServletResponse response, String fileName, String sheetName, List<A> datas, Excelable<A> exporter) {
        HSSFWorkbook wb = new HSSFWorkbook();
        if (StringUtils.isBlank((String)sheetName)) {
            sheetName = "ExportDataList";
        }
        this.createSheet((Workbook)wb, sheetName, datas, exporter);
        if (StringUtils.isBlank((String)fileName)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
            fileName = sdf.format(new Date()) + ".xls";
        }
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        try {
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("export data error", e);
        }
    }

    public <A> Sheet createSheet(Workbook wb, String sheetName, List<A> datas, Excelable<A> exporter) {
        Sheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
        if (datas != null && !datas.isEmpty()) {
            List<ExcelCell[]> result = this.preprocessData(datas, exporter);
            int size = result.size();
            HashMap<ExcelCellStyle, CellStyle> styleMap = new HashMap<ExcelCellStyle, CellStyle>();
            for (int i = 0; i < size; ++i) {
                this.createRow(wb, sheet, i, result.get(i), styleMap);
            }
        }
        return sheet;
    }

    public <A> List<ExcelCell[]> preprocessData(List<A> datas, Excelable<A> exporter) {
        ArrayList<ExcelCell[]> result = new ArrayList<ExcelCell[]>(datas.size() + 1);
        result.add(exporter.exportRowName());
        for (A data : datas) {
            result.add(exporter.exportRowValue(data));
        }
        return result;
    }

    public Row createRow(Workbook wb, Sheet sheet, int rowNum, ExcelCell[] values, Map<ExcelCellStyle, CellStyle> styleMap) {
        Row row = sheet.createRow(rowNum);
        ExcelCell value = null;
        int size = values.length;
        Drawing p = sheet.createDrawingPatriarch();
        for (int i = 0; i < size; ++i) {
            ExcelCellStyle excelCellStyle;
            Cell cell = row.createCell(i);
            value = values[i];
            if (value == null) continue;
            cell.setCellValue(value.getValue().toString());
            if (!StringUtils.isBlank((String)value.getComment())) {
                cell.setCellComment(this.createCellComment(p, value, (short)i, rowNum));
            }
            if (value.getCellType() != null) {
                cell.setCellType(value.getCellType().intValue());
            }
            if ((excelCellStyle = value.getCellStyle()) == null) continue;
            CellStyle cellStyle = styleMap.get(excelCellStyle);
            if (cellStyle == null) {
                cellStyle = wb.createCellStyle();
                styleMap.put(excelCellStyle, cellStyle);
                Font font = null;
                if (excelCellStyle.getAlignment() != null) {
                    cellStyle.setAlignment(excelCellStyle.getAlignment().shortValue());
                }
                if (excelCellStyle.getVerticalAlignment() != null) {
                    cellStyle.setVerticalAlignment(excelCellStyle.getVerticalAlignment().shortValue());
                }
                if (excelCellStyle.getFontColor() != null) {
                    if (font == null) {
                        font = wb.createFont();
                    }
                    font.setColor(excelCellStyle.getFontColor().shortValue());
                }
                if (excelCellStyle.getBoldWeight() != null) {
                    if (font == null) {
                        font = wb.createFont();
                    }
                    font.setBoldweight(excelCellStyle.getBoldWeight().shortValue());
                }
                if (font != null) {
                    cellStyle.setFont(font);
                }
            }
            cell.setCellStyle(cellStyle);
        }
        return row;
    }

    public Comment createCellComment(Drawing draw, ExcelCell value, short col, int row) {
        short col2 = col;
        int row2 = row;
        col2 = (short)(col2 + 1);
        ++row2;
        int len = 0;
        try {
            len = value.getComment().getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (len > 24) {
            col2 = (short)(col + 3);
            row2 = row + (len - 1) / 24 + 1;
        } else {
            col2 = (short)(col + (len + 2) / 9 + 1);
        }
        Comment comment = draw.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 127, col, row, col2, row2));
        comment.setString((RichTextString)new HSSFRichTextString(value.getComment()));
        comment.setVisible(value.isCommentVisible());
        return comment;
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                System.out.println(ex);
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet("ExportDataList");
        Row headerTitle = sheet.createRow(0);
        Cell cell = headerTitle.createCell(0);
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 127;
        short col = 0;
        int row = 0;
        short col2 = 1;
        int row2 = 1;
        String value = "123456789012345";
        int len = 0;
        try {
            len = value.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        System.out.println(len);
        if (len > 24) {
            col2 = (short)(col + 3);
            row2 = row + (len - 1) / 24 + 1;
        } else {
            col2 = (short)(col + (len + 2) / 9 + 1);
            dx2 = (len + 3) % 9 * 113;
        }
        cell.setCellValue(value);
        Drawing draw = sheet.createDrawingPatriarch();
        Comment comment = draw.createCellComment((ClientAnchor)new HSSFClientAnchor(dx1, dy1, dx2, dy2, col, row, col2, row2));
        comment.setString((RichTextString)new HSSFRichTextString(value));
        comment.setVisible(false);
        cell.setCellComment(comment);
        OutputStream os = null;
        try {
            os = new FileOutputStream("/info/" + System.currentTimeMillis() + ".xls");
            wb.write(os);
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                os = null;
            }
        }
    }

    public static class SheetWrapper<T> {
        public String sheetName;
        public List<T> data;
        public String[] fields;
        public String[] fieldValue;

        public static <T> SheetWrapper<T> create() {
            return new SheetWrapper<T>();
        }
    }
}

