/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.date;

import java.beans.PropertyEditorSupport;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeStampPropertyEditor
extends PropertyEditorSupport {
    private static final Logger log = LoggerFactory.getLogger(TimeStampPropertyEditor.class);

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            this.setValue(null);
        } else {
            try {
                long time = Long.parseLong(text);
                if (time <= 0L) {
                    this.setValue(null);
                }
                Date date = new Date(time);
                this.setValue(date);
            }
            catch (Exception e) {
                log.error("Exception e={}", (Throwable)e);
                this.setValue(null);
            }
        }
    }

    @Override
    public String getAsText() {
        Date value = (Date)this.getValue();
        if (value == null) {
            return "";
        }
        try {
            return String.valueOf(value.getTime());
        }
        catch (Exception e) {
            log.error("Exception e={}", (Throwable)e);
            return "";
        }
    }
}

