/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final String EMAIL = "\\w+(\\.\\w+)*@\\w+(\\.\\w+)+";
    public static final String PHONE = "(^(\\d{2,4}[-_\uff0d\u2014]?)?\\d{3,8}([-_\uff0d\u2014]?\\d{3,8})?([-_\uff0d\u2014]?\\d{1,7})?$)|(^0?1[35]\\d{9}$)";
    public static final String MOBILE = "^1[3|4|5|7|8][0-9]\\d{8}$";
    public static final String INTEGER = "^-?(([1-9]\\d*$)|0)";
    public static final String INTEGER_NEGATIVE = "^[1-9]\\d*|0$";
    public static final String INTEGER_POSITIVE = "^-[1-9]\\d*|0$";
    public static final String DOUBLE = "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$";
    public static final String DOUBLE_NEGATIVE = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$";
    public static final String DOUBLE_POSITIVE = "^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$";
    public static final String CODE = "[0-9]\\d{5}(?!\\d)";
    public static final String STR_ENG_NUM_ = "^\\w+$";
    public static final String STR_ENG_NUM = "^[A-Za-z0-9]+";
    public static final String STR_ENG = "^[A-Za-z]+$";
    public static final String STR_SPECIAL = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c'\u3002\uff0c\u3001\uff1f]";
    public static final String DATE_ALL = "((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(10|12|0?[13578])([-\\/\\._]?)(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(11|0?[469])([-\\/\\._]?)(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._]?)(0?2)([-\\/\\._]?)(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([3579][26]00)([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][0][48])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][2468][048])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([1][89][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$)|(^([2-9][0-9][13579][26])([-\\/\\._]?)(0?2)([-\\/\\._]?)(29)$))";
    public static final String DATE_FORMAT1 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";
    public static final String TIME_FORMAT = "([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]";
    public static final String DETE_FORMAT2 = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29) +([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]";
    public static final String URL = "^(http|www|ftp|)?(://)?(\\w+(-\\w+)*)(\\.(\\w+(-\\w+)*))*((:\\d+)?)(/(\\w+(-\\w+)*))*(\\.?(\\w)*)(\\?)?(((\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*(\\w*%)*(\\w*\\?)*(\\w*:)*(\\w*\\+)*(\\w*\\.)*(\\w*&)*(\\w*-)*(\\w*=)*)*(\\w*)*)$";
    public static final String IDCARD = "((11|12|13|14|15|21|22|23|31|32|33|34|35|36|37|41|42|43|44|45|46|50|51|52|53|54|61|62|63|64|65)[0-9]{4})(([1|2][0-9]{3}[0|1][0-9][0-3][0-9][0-9]{3}[Xx0-9])|([0-9]{2}[0|1][0-9][0-3][0-9][0-9]{3}))";
    public static final String STR_NUM = "^[0-9]+$";
    public static final String MAIL = "^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$";

    public static boolean isMail(String mail) {
        return ValidationUtils.regular(mail, MAIL);
    }

    public static synchronized boolean strisNull(String str) {
        return null == str || str.trim().length() <= 0;
    }

    public static boolean strNotNull(String str) {
        return !ValidationUtils.strisNull(str);
    }

    public static String nulltoStr(String str) {
        return ValidationUtils.strisNull(str) ? "" : str;
    }

    public static String nulltoStr(String str, String defaut) {
        return ValidationUtils.strisNull(str) ? defaut : str;
    }

    public static boolean isEmail(String str) {
        return ValidationUtils.regular(str, EMAIL);
    }

    public static boolean isPhone(String str) {
        return ValidationUtils.regular(str, PHONE);
    }

    public static boolean isMobile(String str) {
        return ValidationUtils.regular(str, MOBILE);
    }

    public static boolean isUrl(String str) {
        return ValidationUtils.regular(str, URL);
    }

    public static boolean isNumber(String str) {
        return ValidationUtils.regular(str, DOUBLE);
    }

    public static boolean isInteger(String str) {
        return ValidationUtils.regular(str, INTEGER);
    }

    public static boolean isINTEGER_NEGATIVE(String str) {
        return ValidationUtils.regular(str, INTEGER_NEGATIVE);
    }

    public static boolean isINTEGER_POSITIVE(String str) {
        return ValidationUtils.regular(str, INTEGER_POSITIVE);
    }

    public static boolean isDouble(String str) {
        return ValidationUtils.regular(str, DOUBLE);
    }

    public static boolean isDOUBLE_NEGATIVE(String str) {
        return ValidationUtils.regular(str, DOUBLE_NEGATIVE);
    }

    public static boolean isDOUBLE_POSITIVE(String str) {
        return ValidationUtils.regular(str, DOUBLE_POSITIVE);
    }

    public static boolean isDate(String str) {
        return ValidationUtils.regular(str, DATE_ALL);
    }

    public static boolean isDate1(String str) {
        return ValidationUtils.regular(str, DATE_FORMAT1);
    }

    public static boolean isLengOut(String str, int leng) {
        return ValidationUtils.strisNull(str) ? false : str.trim().length() > leng;
    }

    public static boolean isIdCard(String str) {
        if (ValidationUtils.strisNull(str)) {
            return false;
        }
        if (str.trim().length() == 15 || str.trim().length() == 18) {
            return ValidationUtils.regular(str, IDCARD);
        }
        return false;
    }

    public static boolean isEnglish(String str) {
        return ValidationUtils.regular(str, STR_ENG);
    }

    public static boolean isENG_NUM(String str) {
        return ValidationUtils.regular(str, STR_ENG_NUM);
    }

    public static boolean isENG_NUM_(String str) {
        return ValidationUtils.regular(str, STR_ENG_NUM_);
    }

    public static String filterStr(String str) {
        Pattern p = Pattern.compile(STR_SPECIAL);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isStrNum(String str) {
        return ValidationUtils.regular(str, STR_NUM);
    }

    private static boolean regular(String str, String pattern) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static void main(String[] args) {
        String mobile = "11600119233";
        System.out.println(ValidationUtils.isMobile(mobile));
    }
}

