/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortUrlUtil {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlUtil.class);

    public static String getShortUrl(String longUrl) {
        return ShortUrlUtil.getShortUrl(longUrl, true);
    }

    public static String getHttpsShortUrl(String longUrl) {
        return ShortUrlUtil.txHttpsShortUrl(ShortUrlUtil.getShortUrl(longUrl, true));
    }

    public static String getShortUrl(String longUrl, boolean isSms) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{longUrl}), (Object)"long url is empty");
        try {
            String url = UrlProperties.getProperty("shorturl.api");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("long_url", longUrl);
            params.put("origin", "tianxiao");
            String response = HttpClientUtils.doGet((String)url, params);
            log.info("transfer long  from param={},{} ->:url:{} into short url.={}", new Object[]{url, params, longUrl, response});
            Map responseMap = JacksonUtil.str2Obj(response, Map.class);
            if (responseMap.containsKey("code") && StringUtils.equals((CharSequence)responseMap.get("code").toString(), (CharSequence)"0")) {
                if (responseMap.containsKey("data")) {
                    Map dataMap = (Map)responseMap.get("data");
                    if (isSms) {
                        return ShortUrlUtil.txShortUrl((String)dataMap.get("short_url"));
                    }
                    return ShortUrlUtil.txHttpsShortUrl((String)dataMap.get("short_url"));
                }
            } else {
                log.warn("get short url return false,code={},url={}", responseMap.get("code"), (Object)url);
            }
        }
        catch (Exception e) {
            log.warn("get short url catch error:{} and will return origin url {}", (Object)e, (Object)longUrl);
        }
        return longUrl;
    }

    private static String txShortUrl(String orginGensxShortUrl) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orginGensxShortUrl})) {
            return orginGensxShortUrl.replaceFirst("gensx\\.cn", "tx100.cc");
        }
        return orginGensxShortUrl;
    }

    private static String txHttpsShortUrl(String orginGensxShortUrl) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orginGensxShortUrl})) {
            return orginGensxShortUrl.replaceFirst("http://", "https://");
        }
        return orginGensxShortUrl;
    }
}

