/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtil {
    private static final Logger log = LoggerFactory.getLogger(NumberUtil.class);
    public static final BigDecimal HUNDRED = new BigDecimal(100);
    public static DecimalFormat DOUBLE_FMT = new DecimalFormat("0.00");

    public static long doubleToLong(Double d) {
        BigDecimal data = new BigDecimal(d == null ? 0.0 : d);
        return NumberUtil.multiply(data, HUNDRED, 0).longValue();
    }

    public static double longToDouble(Long d) {
        BigDecimal data = new BigDecimal(d == null ? 0L : d);
        return NumberUtil.get2Double(data.divide(HUNDRED).doubleValue());
    }

    public static BigDecimal multiply(@NonNull Number number1, @NonNull BigDecimal bigDecimal, int scale) {
        if (number1 == null) {
            throw new NullPointerException("number1");
        }
        if (bigDecimal == null) {
            throw new NullPointerException("bigDecimal");
        }
        BigDecimal d1 = new BigDecimal(number1.doubleValue());
        return d1.multiply(bigDecimal).setScale(scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal getHuanBi(Number n1, Number n2) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            BigDecimal b2 = BigDecimal.valueOf(n2.doubleValue());
            if (n2 == null || b2.compareTo(new BigDecimal(0)) == 0) {
                return new BigDecimal(0);
            }
            BigDecimal b1 = BigDecimal.valueOf(n1.doubleValue());
            result = b1.subtract(b2).divide(b2, 2, 6);
        }
        catch (Exception e) {
            log.error("[Divide] Error.", (Throwable)e);
        }
        return result;
    }

    public static double get2Double(double a) {
        DecimalFormat df = new DecimalFormat("0.00");
        return new Double(df.format(a).toString());
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.longToDouble(18733311L));
        System.out.println(NumberUtil.doubleToLong(187333.11));
        System.out.println(NumberUtil.getHuanBi(10, 0.0));
        Double n = 1.0;
        System.out.println(((Object)n).toString());
        System.out.println(NumberUtil.convertFenToYuan(99999L));
        System.out.println(Long.parseLong("501701126786409482"));
    }

    public static String numberWithDelimiter(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String s = decimalFormat.format(d);
        if (s.length() <= 3) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        if (s.startsWith("-")) {
            sb.append(s.substring(1));
        } else {
            sb.append(s);
        }
        int index = sb.toString().indexOf(".");
        while ((index -= 3) > 0) {
            sb.insert(index, ",");
        }
        if (s.startsWith("-")) {
            sb.insert(0, "-");
        } else {
            sb.insert(0, "+");
        }
        return sb.toString();
    }

    public static String get2FromDouble(double a) {
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(a);
    }

    public static Long randomSignupPurchaseId4Excel(Date date) {
        String fixLenthString = String.valueOf((1.0 + new Random().nextDouble()) * Math.pow(10.0, 9.0));
        fixLenthString = fixLenthString.substring(2, 10);
        String str = String.format("%s%s", new SimpleDateFormat("yyMMdd").format(date), fixLenthString);
        return Long.parseLong(str);
    }

    public static double convertMinToHour(Long minutes) {
        if (minutes == null) {
            minutes = 0L;
        }
        BigDecimal decimal = new BigDecimal(minutes);
        BigDecimal base = new BigDecimal(60);
        return decimal.divide(base, 2, 4).doubleValue();
    }

    public static String convertFenToYuan(long amount) {
        BigDecimal decimal = new BigDecimal(amount);
        BigDecimal base = new BigDecimal(100);
        BigDecimal result = decimal.divide(base, 2, 4);
        return result.toString();
    }

    public static String convertMinToHourStr(Long minutes) {
        if (minutes == null) {
            minutes = 0L;
        }
        BigDecimal decimal = new BigDecimal(minutes);
        BigDecimal base = new BigDecimal(60);
        return decimal.divide(base, 1, 4).toString();
    }

    public static double convertMinToHourWithScale(Long minutes, int scale) {
        if (minutes == null) {
            minutes = 0L;
        }
        BigDecimal decimal = new BigDecimal(minutes);
        BigDecimal base = new BigDecimal(60);
        return decimal.divide(base, scale, 4).doubleValue();
    }
}

