/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CourseSmsTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(CourseSmsTokenUtil.class);
    public static final int TOKEN_VERSION = 1;

    public static String encodeToken(Map<String, Object> params) throws Exception {
        return CourseSmsTokenUtil.encodeToken(params, (Long)params.get("orgId"));
    }

    public static String encodeToken(Map<String, Object> params, Long orgId) throws Exception {
        return CourseSmsTokenUtil.encodeExpireToken(params, orgId, DateUtil.getDiffDateTime(new Date(), 2));
    }

    public static String encodeExpireToken(Map<String, Object> params, Long orgId, Date expireDate) throws Exception {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        SmsToken token = new SmsToken();
        token.setOrgId(orgId);
        token.getParams().putAll(params);
        token.setTs(expireDate);
        token.setVersion(1);
        return EncryptUtils.base64EncodeStrWithFactor(token);
    }

    public static SmsToken decodeToken(String token) throws Exception {
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String jsonStr = EncryptUtils.strDecode(token);
        try {
            return JacksonUtil.str2Obj(jsonStr, SmsToken.class);
        }
        catch (Exception e) {
            log.warn("decode token error! token:{}, jsonStr:{}, e:{}", new Object[]{token, jsonStr, e});
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        String token = "H4Ipe3opQTg7QDw8OT05OTw-OTczKXZ5blBrKUE9ODo9OzQqeGl6aXV7KkKDKnxtaWtwbXpRbCpCOz9BOkA6QjUreHlud1JtK0MreHx5UlR8PUpbSlM-cVZsaHRgUlpfWFdSUn5UfSw2";
        String jsonStr = EncryptUtils.strDecode(token);
        System.out.println(jsonStr);
        String content = "{l_mac=1b99d794-9983-3b8e-b97a-adccbc605ff3, scheme=bjhltx, os=android-24, signature=ad6be8908a97e25d6\n816d6d2c6f24242, channel=HuaWeiStore, pageSize=20, l_imei=863444032761062, uuid=1b99d794-9983-3b8e-b97a-adccbc605ff3, version=2.2.1, pageNum=1, platform=android-HUAWEI:FRD-AL10, startTime=1495296000141, logId=4\nd97eb79-9aa4-420c-8514-19180b02e79a, endTime=1495382400141, auth_token=HYAnenhqd2RuaSc_Ozg8ODkxJ2h5Jz82OT46Ojo7Ojc9Mih5Z3J6KEAob3VNfzpWaD0oMih6fmVpZ3lqaGtsZnx6bHlmcGspQTo8PUAzKXt_ZmhqanZ8dXxncWwqQnZ9dHQ0KnyAZ35\nxe3F8d3pncWwqQnZ9dXU1K2psbHh-d31fbnt8cnh3K0M6NStqeXlOd38sRCx5eHZzeG8sNix-gnB8eXdpeXxxaXNuLER4f3d3Ny1qUX16eGp4bH5_cH0tRXmAd3eI, timestamp=1495556428877}";
        String encodeStr = EncryptUtils.base64EncodeStrWithFactor(content);
        System.out.println(encodeStr);
        String decodeStr = EncryptUtils.strDecode(encodeStr);
        System.out.println(decodeStr);
        System.out.println(decodeStr.equals(content));
        System.out.println();
        encodeStr = "BYAneXgnQDc6Pz49OD4_ODo_QD80K3h7cFJuLEQ_Ozw_PjctfG1-bXmAL0eIL4Jzb3F2dIFYczFKQ0NCRkdFSD0zgYJ3gFt3NU01gkR5gnyKiFhbZl1-hpBYTX1qhXhcYoVdgYSJWjtFO4mMgWN-PVVQTExQT0g-k4KAhX6RX46OZ4JBWUGWl1CCU4VZUlpXU4dZVlNVVFNFoE9FmomWl42Uk0dfVqM";
        System.out.println(CourseSmsTokenUtil.decodeToken(encodeStr));
    }

    public static class SmsToken {
        private Date ts;
        private Long orgId;
        private Map<String, Object> params = new HashMap<String, Object>();
        private Integer version;

        public void put(String key, Object value) {
            this.params.put(key, value);
        }

        public Date getTs() {
            return this.ts;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setTs(Date ts) {
            this.ts = ts;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public void setParams(Map<String, Object> params) {
            this.params = params;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmsToken)) {
                return false;
            }
            SmsToken other = (SmsToken)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$ts = this.getTs();
            Date other$ts = other.getTs();
            if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
                return false;
            }
            Long this$orgId = this.getOrgId();
            Long other$orgId = other.getOrgId();
            if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
                return false;
            }
            Map<String, Object> this$params = this.getParams();
            Map<String, Object> other$params = other.getParams();
            if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmsToken;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $ts = this.getTs();
            result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
            Long $orgId = this.getOrgId();
            result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
            Map<String, Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            return result;
        }

        public String toString() {
            return "CourseSmsTokenUtil.SmsToken(ts=" + this.getTs() + ", orgId=" + this.getOrgId() + ", params=" + this.getParams() + ", version=" + this.getVersion() + ")";
        }
    }
}

